/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.Collection;
import java.util.Date;
import org.caudexorigo.time.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.InternalPublisher;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.QueueProcessorList;

class QueueCounter
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(QueueCounter.class);

    QueueCounter() {
    }

    @Override
    public void run() {
        Collection<QueueProcessor> qpl = QueueProcessorList.values();
        log.debug("Number of registered Queues: {}", (Object)qpl.size());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", ISO8601.format((Date)new Date()), GcsInfo.getAgentName()));
        for (QueueProcessor qp : QueueProcessorList.values()) {
            long cnt = qp.getQueuedMessagesCount();
            boolean sendstats = true;
            if (cnt == 0L) {
                if (!qp.emptyQueueInfoDisplay.getAndSet(true)) {
                    log.info("Queue '{}' is empty.", (Object)qp.getQueueName());
                } else {
                    sendstats = false;
                }
            } else if (cnt == 1L) {
                log.info("Queue '{}' has 1 message.", (Object)qp.getQueueName());
            } else if (cnt > 1L) {
                log.info("Queue '{}' has {} messages.", (Object)qp.getQueueName(), (Object)cnt);
            }
            if (!sendstats) continue;
            sb.append(String.format("\n\t<item subject='queue://%s' predicate='queue-size' value='%s' />", qp.getQueueName(), cnt));
        }
        sb.append("\n</mqinfo>");
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/queues/#%s#", GcsInfo.getAgentName());
        InternalPublisher.send(sys_topic, result);
    }
}

