/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class QueueStatistics {
    private final AtomicLong qReceivedMessages = new AtomicLong(0L);
    private final AtomicBoolean qReceivedPublish = new AtomicBoolean(true);
    private final AtomicLong qDeliveredMessages = new AtomicLong(0L);
    private final AtomicBoolean qDeliveredPublish = new AtomicBoolean(true);
    private final AtomicLong qRedeliveredMessages = new AtomicLong(0L);
    private final AtomicBoolean qRedeliveredPublish = new AtomicBoolean(true);
    private final AtomicLong qExpiredMessages = new AtomicLong(0L);
    private final AtomicBoolean qExpiredPublish = new AtomicBoolean(true);

    public final void newQueueMessageReceived() {
        this.qReceivedMessages.incrementAndGet();
    }

    public long getQueueMessagesReceivedAndReset() {
        return this.getPublishInformation(this.qReceivedMessages, this.qReceivedPublish);
    }

    public final void newQueueMessageDelivered() {
        this.qDeliveredMessages.incrementAndGet();
    }

    public long getQueueMessagesDeliveredAndReset() {
        return this.getPublishInformation(this.qDeliveredMessages, this.qDeliveredPublish);
    }

    public final void newQueueRedeliveredMessage() {
        this.qRedeliveredMessages.incrementAndGet();
    }

    public final long getQueueMessagesRedeliveredAndReset() {
        return this.getPublishInformation(this.qRedeliveredMessages, this.qRedeliveredPublish);
    }

    public final void newQueueExpiredMessage() {
        this.qExpiredMessages.incrementAndGet();
    }

    public final long getQueueMessagesExpiredAndReset() {
        return this.getPublishInformation(this.qExpiredMessages, this.qExpiredPublish);
    }

    private long getPublishInformation(AtomicLong value, AtomicBoolean status) {
        long retValue = value.getAndSet(0L);
        if (retValue == 0L) {
            retValue = status.getAndSet(false) ? 0L : -1L;
        } else {
            status.set(true);
        }
        return retValue;
    }
}

