/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.gcs.messaging.Gcs;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.QueueProcessorList;

public class StaleQueueCleaner
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(StaleQueueCleaner.class);
    private Optional<String> queuePrefix;
    private Long queueMaxStaleAge;

    public StaleQueueCleaner(Optional<String> queuePrefix, Long queueMaxStaleAge) {
        Preconditions.checkNotNull(queuePrefix, (Object)"The queuePrefix cannot be null.");
        Preconditions.checkNotNull((Object)queueMaxStaleAge, (Object)"The queueMaxStaleAge cannot be null.");
        this.queuePrefix = queuePrefix;
        this.queueMaxStaleAge = queueMaxStaleAge;
    }

    private Collection<QueueProcessor> getProcessors() {
        if (this.queuePrefix.isPresent()) {
            return QueueProcessorList.findByPattern((String)this.queuePrefix.get());
        }
        return QueueProcessorList.values();
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Running Stale Queue Cleaner: {}", (Object)(this.queuePrefix.isPresent() ? (String)this.queuePrefix.get() : "global"));
        }
        long now = System.currentTimeMillis();
        ArrayList<String> to_remove = new ArrayList<String>();
        Collection<QueueProcessor> processors = this.getProcessors();
        for (QueueProcessor qp : processors) {
            long lastDeliveredMsg = qp.lastMessageDelivered();
            long qstaleAge = now - lastDeliveredMsg;
            if (qstaleAge >= this.queueMaxStaleAge && (this.queuePrefix.isPresent() || !QueueProcessorList.get(qp.getQueueName()).hasRecipient())) {
                to_remove.add(qp.getQueueName());
            }
            if (!log.isDebugEnabled()) continue;
            String msg = String.format("Queue '%s' maxStaleAge: %s; lastDeliveredMsg: %s; qstaleAge: %s", qp.getQueueName(), this.queueMaxStaleAge, lastDeliveredMsg, qstaleAge);
            log.debug(msg);
        }
        int qdelete = to_remove.size();
        for (String queueName : to_remove) {
            Gcs.deleteQueue(queueName, false);
            log.debug("Deleted stale queue '{}'", (Object)queueName);
        }
        log.info("Deleted queues: {}. Number of active queues: {}", (Object)qdelete, (Object)QueueProcessorList.values().size());
    }
}

