/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicStatistics {
    private static final Logger log = LoggerFactory.getLogger(TopicStatistics.class);
    private final AtomicLong tDeliveredMessages = new AtomicLong(0L);
    private final AtomicBoolean tDeliveredPublish = new AtomicBoolean(true);
    private final AtomicLong tDiscardedMessages = new AtomicLong(0L);
    private final AtomicBoolean tDiscardedPublish = new AtomicBoolean(true);
    private final AtomicLong tTopicDispatchedToQueueMessages = new AtomicLong(0L);
    private final AtomicBoolean tTopicDispatchedToQueuePublish = new AtomicBoolean(true);

    public final void newTopicMessageDelivered() {
        this.tDeliveredMessages.incrementAndGet();
        log.debug("Total delivered messages: {}", (Object)this.tDeliveredMessages.get());
    }

    public long getTopicMessagesDeliveredAndReset() {
        return this.getPublishInformationInformation(this.tDeliveredMessages, this.tDeliveredPublish);
    }

    public final void newTopicDiscardedMessage() {
        this.tDiscardedMessages.incrementAndGet();
    }

    public final long getTopicMessagesDiscardedAndReset() {
        return this.getPublishInformationInformation(this.tDiscardedMessages, this.tDiscardedPublish);
    }

    public final void newTopicDispatchedToQueueMessage() {
        this.tTopicDispatchedToQueueMessages.incrementAndGet();
    }

    public final long getTopicMessagesDispatchedToQueueAndReset() {
        return this.getPublishInformationInformation(this.tTopicDispatchedToQueueMessages, this.tTopicDispatchedToQueuePublish);
    }

    private long getPublishInformationInformation(AtomicLong value, AtomicBoolean status) {
        long retValue = value.getAndSet(0L);
        if (retValue == 0L) {
            retValue = status.getAndSet(false) ? 0L : -1L;
        } else {
            status.set(true);
        }
        return retValue;
    }
}

