/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging.statistics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.NetAction;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.statistics.KpiStatistics;
import pt.com.gcs.stats.ChannelStatistics;
import pt.com.gcs.stats.QueueStatistics;
import pt.com.gcs.stats.Statistics;
import pt.com.gcs.stats.SystemStatistics;
import pt.com.gcs.stats.TopicStatistics;
import pt.sapo.socialbus.common.kpi.EventBuilder;
import pt.sapo.socialbus.common.kpi.data.Event;
import pt.sapo.socialbus.common.kpi.data.MetricItem;
import pt.sapo.socialbus.common.kpi.data.MetricType;

public class KpiGlobalStatisticsPublisher {
    private static final Logger log = LoggerFactory.getLogger(KpiGlobalStatisticsPublisher.class);
    private final Date date;
    private final Statistics statistics;

    public KpiGlobalStatisticsPublisher(Date date, Statistics statistics) {
        this.date = date;
        this.statistics = statistics;
    }

    public void publishStatistics() {
        ArrayList kpiEvents = Lists.newArrayList();
        kpiEvents.addAll(this.getQeueInfoKpis());
        kpiEvents.addAll(this.getTopicInfoKpis());
        kpiEvents.addAll(this.getChannelInfoKpis());
        kpiEvents.addAll(this.getMiscInformationKpis());
        KpiStatistics.publishKpiEvents(kpiEvents);
    }

    private EventBuilder getEventBuilder(String destinationType) {
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(Long.valueOf(this.date.getTime())).setDomain("broker.bk.sapo.pt").addStringAttribute("agent-name", GcsInfo.getAgentName());
        if (destinationType != null) {
            eventBuilder.addStringAttribute("destination-type", destinationType);
        }
        return eventBuilder;
    }

    private double getStatsValue(long value) {
        if (value == -1L) {
            return 0.0;
        }
        return value;
    }

    private double getStatsValue(long value, String name) {
        double doubleVal = this.getStatsValue(value);
        log.debug("Long value for metric {}: {}", (Object)name, (Object)value);
        log.debug("Double value for metric {}: {}", (Object)name, (Object)doubleVal);
        return doubleVal;
    }

    private List<Event> getQeueInfoKpis() {
        ArrayList kpis = Lists.newArrayList();
        for (QueueStatistics queueStats : this.statistics.getQueueStatistics()) {
            EventBuilder eventBuilder = this.getEventBuilder(NetAction.DestinationType.QUEUE.toString());
            eventBuilder.addStringAttribute("queue-name", queueStats.getQueueName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-received", Double.valueOf(this.getStatsValue(queueStats.getReceivedMessages()))));
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-delivered", Double.valueOf(this.getStatsValue(queueStats.getDeliveredMessages()))));
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-expired", Double.valueOf(this.getStatsValue(queueStats.getExpiredMessages()))));
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-redelivered", Double.valueOf(this.getStatsValue(queueStats.getRedeliveredMessages()))));
            kpis.add(eventBuilder.buildMetricBundleEvent());
        }
        return kpis;
    }

    private List<Event> getTopicInfoKpis() {
        ArrayList kpis = Lists.newArrayList();
        for (TopicStatistics topicStats : this.statistics.getTopicStatistics()) {
            EventBuilder eventBuilder = this.getEventBuilder(NetAction.DestinationType.TOPIC.toString());
            eventBuilder.addStringAttribute("topic-name", topicStats.getTopicName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-delivered", Double.valueOf(this.getStatsValue(topicStats.getDeliveredMessages(), "messages-delivered"))));
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-discarded", Double.valueOf(this.getStatsValue(topicStats.getDiscardedMessages()))));
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-dispatched", Double.valueOf(this.getStatsValue(topicStats.getDispatchedToQueueMessages()))));
            kpis.add(eventBuilder.buildMetricBundleEvent());
        }
        return kpis;
    }

    private List<Event> getChannelInfoKpis() {
        ArrayList kpis = Lists.newArrayList();
        for (ChannelStatistics channelStats : this.statistics.getChannelStatistics()) {
            EventBuilder eventBuilder = this.getEventBuilder(channelStats.getChannelName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-received", Double.valueOf(this.getStatsValue(channelStats.getReceivedMessages()))));
            kpis.add(eventBuilder.buildMetricBundleEvent());
        }
        return kpis;
    }

    private List<Event> getMiscInformationKpis() {
        ArrayList kpis = Lists.newArrayList();
        SystemStatistics systemStats = this.statistics.getSystemStatistics();
        EventBuilder eventBuilder = this.getEventBuilder(null);
        eventBuilder.addStringAttribute("stats", "messages");
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-invalid", Double.valueOf(this.getStatsValue(systemStats.getInvalidMessages()))));
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-access-denied", Double.valueOf(this.getStatsValue(systemStats.getAccessDeniedMessages()))));
        kpis.add(eventBuilder.buildMetricBundleEvent());
        eventBuilder = this.getEventBuilder(null);
        eventBuilder.addStringAttribute("stats", "connections");
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "tcp", Double.valueOf(this.getStatsValue(systemStats.getTcpConnections()))));
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "tcp", Double.valueOf(this.getStatsValue(systemStats.getTcpLegacyConnections()))));
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "ssl", Double.valueOf(this.getStatsValue(systemStats.getSslConnections()))));
        kpis.add(eventBuilder.buildMetricBundleEvent());
        eventBuilder = this.getEventBuilder(null);
        eventBuilder.addStringAttribute("stats", "system");
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "messages-delivery-failed", Double.valueOf(this.getStatsValue(systemStats.getFailedMessages()))));
        eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "faults", Double.valueOf(this.getStatsValue(systemStats.getSystemFaults()))));
        kpis.add(eventBuilder.buildMetricBundleEvent());
        return kpis;
    }
}

