/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging.statistics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.stats.ChannelStats;
import pt.com.broker.types.stats.MiscStats;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.QueueProcessorList;
import pt.com.gcs.messaging.TopicProcessor;
import pt.com.gcs.messaging.TopicProcessorList;
import pt.com.gcs.messaging.statistics.KpiGlobalStatisticsPublisher;
import pt.com.gcs.stats.ChannelStatistics;
import pt.com.gcs.stats.QueueStatistics;
import pt.com.gcs.stats.Statistics;
import pt.com.gcs.stats.SystemStatistics;
import pt.com.gcs.stats.TopicStatistics;

public class StatisticsCollector
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StatisticsCollector.class);
    private static volatile Date date = new Date();

    @Override
    public void run() {
        try {
            Date oldDate = date;
            date = new Date();
            Statistics stats = this.getStatistics();
            KpiGlobalStatisticsPublisher kpiStatsPublisher = new KpiGlobalStatisticsPublisher(date, stats);
            kpiStatsPublisher.publishStatistics();
        }
        catch (Exception e) {
            log.error("Unhandled exception caught collecting agent statistics.", (Throwable)e);
        }
    }

    private Statistics getStatistics() {
        Statistics statistics = new Statistics();
        this.getQueueStats(statistics);
        this.getTopicStats(statistics);
        this.getChannelStats(statistics);
        this.getSystemStats(statistics);
        return statistics;
    }

    private void getQueueStats(Statistics statistics) {
        ArrayList queueStatistics = Lists.newArrayList();
        for (QueueProcessor qp : QueueProcessorList.values()) {
            QueueStatistics queueStats = new QueueStatistics();
            queueStats.setQueueName(qp.getQueueName());
            queueStats.setReceivedMessages(qp.getQueueStatistics().getQueueMessagesReceivedAndReset());
            queueStats.setDeliveredMessages(qp.getQueueStatistics().getQueueMessagesDeliveredAndReset());
            queueStats.setExpiredMessages(qp.getQueueStatistics().getQueueMessagesExpiredAndReset());
            queueStats.setRedeliveredMessages(qp.getQueueStatistics().getQueueMessagesRedeliveredAndReset());
            queueStatistics.add(queueStats);
        }
        statistics.setQueueStatistics(queueStatistics);
    }

    private void getTopicStats(Statistics statistics) {
        ArrayList topicStatistics = Lists.newArrayList();
        for (TopicProcessor tp : TopicProcessorList.values()) {
            TopicStatistics topicStats = new TopicStatistics();
            topicStats.setTopicName(tp.getSubscriptionName());
            topicStats.setDeliveredMessages(tp.getTopicStatistics().getTopicMessagesDeliveredAndReset());
            topicStats.setDiscardedMessages(tp.getTopicStatistics().getTopicMessagesDiscardedAndReset());
            topicStats.setDispatchedToQueueMessages(tp.getTopicStatistics().getTopicMessagesDispatchedToQueueAndReset());
            topicStatistics.add(topicStats);
        }
        statistics.setTopicStatistics(topicStatistics);
    }

    private void getChannelStats(Statistics statistics) {
        ArrayList channelStatistics = Lists.newArrayList();
        ChannelStatistics channelStats = new ChannelStatistics();
        channelStats.setChannelName("dropbox");
        channelStats.setReceivedMessages(ChannelStats.getDropboxReceivedMessagesAndReset());
        channelStatistics.add(channelStats);
        statistics.setChannelStatistics(channelStatistics);
    }

    private void getSystemStats(Statistics statistics) {
        SystemStatistics systemStats = new SystemStatistics();
        systemStats.setInvalidMessages(MiscStats.getInvalidMessagesAndReset());
        systemStats.setAccessDeniedMessages(MiscStats.getAccessesDeniedAndReset());
        systemStats.setTcpConnections(MiscStats.getTcpConnections());
        systemStats.setTcpLegacyConnections(MiscStats.getTcpLegacyConnections());
        systemStats.setSslConnections(MiscStats.getSslConnections());
        systemStats.setFailedMessages(MiscStats.getSystemMessagesFailuresAndReset());
        systemStats.setSystemFaults(MiscStats.getFaultsAndReset());
        systemStats.setReceivedTopicMessages(TopicProcessorList.getTopicMessagesReceivedAndReset());
        statistics.setSystemStatistics(systemStats);
    }
}

