/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.net.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.gcs.messaging.GcsAcceptorProtocolHandler;
import pt.com.gcs.net.codec.GcsCodec;
import pt.com.gcs.net.ssl.RequiredSslException;

public class GcsHandler
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(GcsHandler.class);
    private final SslContext sslCtx;
    private final boolean forceSsl;

    public GcsHandler(SslContext sslCtx, boolean forceSsl) {
        this.sslCtx = sslCtx;
        this.forceSsl = forceSsl;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 4) {
            ChannelPipeline p = ctx.pipeline();
            if (SslHandler.isEncrypted((ByteBuf)in)) {
                log.debug("SSL Support added to the channel.");
                p.addLast("broker-ssl-handler", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
            } else {
                if (this.forceSsl) {
                    log.error("Ssl is mandatory for all agent communications.");
                    ctx.close();
                    throw new RequiredSslException();
                }
                log.warn("No SSL Support. All communications between {} and {} will be unsecured.", (Object)ctx.channel().localAddress().toString(), (Object)ctx.channel().remoteAddress().toString());
            }
            p.addLast("broker-codec", (ChannelHandler)new GcsCodec());
            p.addLast("broker-handler", (ChannelHandler)new GcsAcceptorProtocolHandler());
            p.remove((ChannelHandler)this);
        }
    }
}

