/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import pt.com.broker.client.nio.codecs.BindingSerializerFactory;
import pt.com.broker.client.nio.codecs.BrokerMessageEncoder;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;

@RunWith(value=Parameterized.class)
public class TestMessageEncoding {
    List<ByteBuf> data = new ArrayList<ByteBuf>(10);
    protected BindingSerializer serializer = null;

    public TestMessageEncoding(BindingSerializer serializer) {
        this.serializer = (BindingSerializer)Mockito.spy((Object)serializer);
    }

    @Parameterized.Parameters
    public static Collection primeNumbers() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        ArrayList<Object[]> serializers = new ArrayList<Object[]>(7);
        serializers.add(new Object[]{BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON)});
        serializers.add(new Object[]{BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.PROTOCOL_BUFFER)});
        serializers.add(new Object[]{BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.SOAP)});
        serializers.add(new Object[]{BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.THRIFT)});
        return serializers;
    }

    @Test
    public void testSerializer() {
        BrokerMessageEncoder encoder = new BrokerMessageEncoder(this.serializer);
        EmbeddedChannel channel = this.createChannel((ChannelHandler)encoder);
        NetMessage netMessage = NetFault.InvalidAuthenticationChannelType;
        channel.writeOutbound(new Object[]{netMessage});
        ((BindingSerializer)Mockito.verify((Object)this.serializer)).marshal(netMessage);
        ByteBuf buf = this.data.get(0);
        Assert.assertNotNull((Object)buf);
        short encType = buf.readShort();
        Assert.assertEquals((long)encType, (long)this.getProtocolType(this.serializer.getProtocolType()));
        short encVersion = buf.readShort();
        Assert.assertEquals((long)encVersion, (long)0L);
        int len = buf.readInt();
        Assert.assertThat((Object)len, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((long)len, (long)buf.readableBytes());
        buf.readBytes(len);
        Assert.assertEquals((long)0L, (long)buf.readableBytes());
    }

    private EmbeddedChannel createChannel(ChannelHandler handler) {
        return new EmbeddedChannel(new ChannelHandler[]{new MockOutboundHandler(), handler});
    }

    protected short getProtocolType(NetProtocolType protocolType) {
        short proto_type = 0;
        switch (protocolType) {
            case SOAP: {
                proto_type = 0;
                break;
            }
            case PROTOCOL_BUFFER: {
                proto_type = 1;
                break;
            }
            case THRIFT: {
                proto_type = 2;
                break;
            }
            case JSON: {
                proto_type = 3;
                break;
            }
            case SOAP_v0: {
                proto_type = 0;
                break;
            }
            default: {
                throw new RuntimeException("Invalid Protocol Type: " + this.serializer.getProtocolType());
            }
        }
        return proto_type;
    }

    private class MockOutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private MockOutboundHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            TestMessageEncoding.this.data.add(((ByteBuf)msg).copy());
            promise.setSuccess();
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
        }
    }
}

