/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import pt.com.broker.client.nio.events.connection.ConnectionEventListener;
import pt.com.broker.client.nio.events.connection.ConnectionStatusChangeEventImpl;
import pt.com.broker.client.nio.handlers.ConnectionStatusChangeEventHandler;
import pt.com.broker.client.nio.server.HostInfo;

public class TestConnectionStatusEventListener {
    private final ConnectionEventListener eventListener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
    private final List<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>();
    private final HostInfo localhost = new HostInfo("localhost", 3323);
    private EmbeddedChannel channel;

    @Before
    public void setup() {
        this.connectionEventListeners.add(this.eventListener);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new ConnectionStatusChangeEventHandler(this.connectionEventListeners)});
    }

    @Test
    public void testConnectionStatusEventConnected() {
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(this.localhost, HostInfo.STATUS.OPEN));
        ((ConnectionEventListener)Mockito.verify((Object)this.eventListener)).connected(this.localhost);
    }

    @Test
    public void testConnectionStatusEventDisconnected() {
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(this.localhost, HostInfo.STATUS.CLOSED));
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(this.localhost, HostInfo.STATUS.DISABLE));
        ((ConnectionEventListener)Mockito.verify((Object)this.eventListener, (VerificationMode)Mockito.times((int)2))).disconnected(this.localhost);
    }
}

