/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.consumer.ConsumerManager;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.handlers.ReceiveMessageHandler;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.tests.mockito.DecoratorMatcher;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;
import pt.com.broker.types.NetSubscribeAction;

@RunWith(value=MockitoJUnitRunner.class)
public class TestNotificationListener {
    @Mock
    BrokerClient bk;

    @Test
    public void testHandlerCallPublic() throws Throwable {
        ConsumerManager consumerManager = (ConsumerManager)Mockito.spy((Object)new ConsumerManager());
        NotificationListenerAdapter listener = (NotificationListenerAdapter)Mockito.spy((Object)((Object)new MyNotificationListener()));
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        listener.setBrokerClient(this.bk);
        NetSubscribe subscribe = new NetSubscribe("/teste/", NetAction.DestinationType.QUEUE);
        consumerManager.addSubscription((NetSubscribeAction)subscribe, (BrokerListener)listener, host);
        ReceiveMessageHandler receiveMessageHandler = new ReceiveMessageHandler(consumerManager);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{receiveMessageHandler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        decorator.setHost(host);
        NetBrokerMessage netBrokerMessage = new NetBrokerMessage("teste");
        NetNotification notification = new NetNotification(subscribe.getDestination(), subscribe.getDestinationType(), netBrokerMessage, subscribe.getDestination());
        NetMessage message = new NetMessage(new NetAction(notification));
        channel.writeInbound(new Object[]{message});
        Mockito.when((Object)listener.onMessage(notification, host)).thenReturn((Object)true);
        ((NotificationListenerAdapter)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).deliverMessage(message, host);
        ((ConsumerManager)Mockito.verify((Object)consumerManager, (VerificationMode)Mockito.times((int)1))).deliverMessage(message, host);
        ((BrokerClient)Mockito.verify((Object)this.bk)).acknowledge((NetNotification)Mockito.argThat((Matcher)new DecoratorMatcher(notification)), (HostInfo)Mockito.eq((Object)host));
    }

    public class MyNotificationListener
    extends NotificationListenerAdapter {
        public boolean onMessage(NetNotification notification, HostInfo host) {
            return true;
        }
    }
}

