/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import pt.com.broker.client.nio.bootstrap.BaseBootstrap;
import pt.com.broker.client.nio.bootstrap.BaseChannelInitializer;
import pt.com.broker.client.nio.bootstrap.Bootstrap;
import pt.com.broker.client.nio.bootstrap.ChannelInitializer;
import pt.com.broker.client.nio.codecs.BindingSerializerFactory;
import pt.com.broker.client.nio.consumer.PongConsumerManager;
import pt.com.broker.client.nio.mocks.SocketServer;
import pt.com.broker.client.nio.server.HostContainer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.server.ServerBaseTest;
import pt.com.broker.client.nio.tests.Utils;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetProtocolType;

public class TestServerConnection
extends ServerBaseTest {
    @Test
    public void testConnection() throws ExecutionException, InterruptedException, TimeoutException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        List<SocketServer> servers = this.getServers();
        BindingSerializer serializer = BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON);
        Bootstrap b = new Bootstrap((BaseChannelInitializer)new ChannelInitializer(serializer, null, null, null), (ByteBufAllocator)new PooledByteBufAllocator(true));
        HostContainer container = new HostContainer((BaseBootstrap)b);
        for (SocketServer server : servers) {
            HostInfo host = new HostInfo("127.0.0.1", server.getPort());
            host.setReaderIdleTime(4000L);
            host.setWriterIdleTime(2000L);
            container.add(host);
        }
        Future future = container.connectAsync();
        HostInfo hostInfo = (HostInfo)future.get(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)hostInfo);
        this.ShutDownServers(servers);
    }

    @Test
    public void testClosedServers() throws InterruptedException, TimeoutException, ExecutionException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.skipTest(Utils.isAndroid())) {
            return;
        }
        List<SocketServer> servers = this.getServers();
        BindingSerializer serializer = BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON);
        HostContainer container = new HostContainer((BaseBootstrap)new Bootstrap((BaseChannelInitializer)new ChannelInitializer(serializer, null, null, null), (ByteBufAllocator)new PooledByteBufAllocator(true)));
        for (SocketServer server : servers) {
            container.add(new HostInfo("127.0.0.1", server.getPort()));
        }
        int total_servers = container.size();
        Future future = container.connectAsync();
        HostInfo host = (HostInfo)future.get(20000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)host);
        Assert.assertTrue((boolean)host.isActive());
        System.out.println("------------------------------------");
        Thread.sleep(4000L);
        for (HostInfo chost : container.getConnectedHosts()) {
            System.out.println("Status: " + chost.getStatus());
        }
        List<SocketServer> rservers = this.getRandomServers(servers);
        System.out.println("Random servers: " + rservers.size());
        this.ShutDownServers(rservers);
        Thread.sleep(4000L);
        int not_connected = container.notConnectedHosts().size();
        int connected_servers = container.getConnectedSize();
        for (HostInfo chost : container.getConnectedHosts()) {
            System.out.println("Status: " + chost.getStatus());
        }
        System.out.println("Connected Servers: " + connected_servers);
        System.out.println("Not Connected Servers: " + not_connected);
        Assert.assertEquals((long)total_servers, (long)(not_connected + connected_servers));
        this.ShutDownServers(servers);
        container.disconnect().get();
        for (HostInfo chost : container.notConnectedHosts()) {
            System.out.println("Status: " + chost.getStatus());
        }
        Thread.sleep(4000L);
    }

    @Test
    public void testHeartbeat() throws IOException, InterruptedException, TimeoutException, ExecutionException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.skipTest(Utils.isAndroid())) {
            return;
        }
        if (!this.userHasPermissions()) {
            return;
        }
        List<SocketServer> servers = this.getServers();
        BindingSerializer serializer = BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON);
        Bootstrap bootstrap = new Bootstrap((BaseChannelInitializer)new ChannelInitializer(serializer, null, new PongConsumerManager(), null), (ByteBufAllocator)new PooledByteBufAllocator(true));
        HostContainer container = new HostContainer((BaseBootstrap)bootstrap);
        for (SocketServer server : servers) {
            HostInfo hostInfo = new HostInfo("127.0.0.1", server.getPort());
            hostInfo.setConnectTimeout(500);
            hostInfo.setReaderIdleTime(4000L);
            hostInfo.setWriterIdleTime(2000L);
            container.add(hostInfo);
        }
        Future future = container.connectAsync();
        HostInfo host = (HostInfo)future.get(20000L, TimeUnit.MILLISECONDS);
        Thread.sleep(2000L);
        List<SocketServer> random_servers = this.getRandomServers(servers);
        for (SocketServer s : random_servers) {
            if (!ipTables.blockPort(TestServerConnection.currentChainName(), s.getPort())) {
                System.out.println("Error blocking port");
            }
            System.out.println("Blocking server: " + s.getPort());
        }
        int blockedservers = random_servers.size();
        Thread.sleep(15000L);
        int connected_servers = container.getConnectedHosts().size();
        System.out.println("Connected Servers: " + connected_servers);
        System.out.println("Blocked Servers: " + blockedservers);
        Assert.assertEquals((long)container.size(), (long)(connected_servers + blockedservers));
        this.ShutDownServers(servers);
    }

    @Test
    public void testHeartbeatWithReconnect() throws IOException, InterruptedException, TimeoutException, ExecutionException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!this.userHasPermissions()) {
            return;
        }
        List<SocketServer> servers = this.getServers();
        BindingSerializer serializer = BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON);
        Bootstrap bootstrap = new Bootstrap((BaseChannelInitializer)new ChannelInitializer(serializer, null, new PongConsumerManager(), null), (ByteBufAllocator)new PooledByteBufAllocator(true));
        HostContainer container = new HostContainer((BaseBootstrap)bootstrap);
        for (SocketServer server : servers) {
            HostInfo host = new HostInfo("127.0.0.1", server.getPort());
            host.setConnectTimeout(500);
            host.setReaderIdleTime(4000L);
            host.setWriterIdleTime(2000L);
            container.add(host);
        }
        Future future = container.connectAsync();
        HostInfo host = (HostInfo)future.get(20000L, TimeUnit.MILLISECONDS);
        Thread.sleep(2000L);
        List<SocketServer> random_servers = this.getRandomServers(servers);
        for (SocketServer s : random_servers) {
            if (!ipTables.blockPort(TestServerConnection.currentChainName(), s.getPort())) {
                System.out.println("Error blocking port");
            }
            System.out.println("Blocking server: " + s.getPort());
        }
        System.out.println("------ sleeping-------");
        Thread.sleep(10000L);
        int blockedservers = random_servers.size();
        int connected_servers = container.getConnectedSize();
        System.out.println("Connected Servers: " + connected_servers);
        System.out.println("Blocked Servers: " + blockedservers);
        Assert.assertEquals((long)container.getHostsSize(), (long)(connected_servers + blockedservers));
        for (SocketServer s : random_servers) {
            if (!ipTables.removePortBlock(TestServerConnection.currentChainName(), s.getPort())) {
                System.out.println("Error ublocking port");
            }
            System.out.println("Unblocking server: " + s.getPort());
        }
        Thread.sleep(10000L);
        connected_servers = container.getConnectedSize();
        System.out.println("Total Servers: " + servers.size());
        System.out.println("Connected Servers: " + connected_servers);
        Assert.assertEquals((long)container.getHostsSize(), (long)connected_servers);
        this.ShutDownServers(servers);
    }
}

