/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.mocks.SocketServer;
import pt.com.broker.client.nio.server.HostContainer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.server.ServerBaseTest;
import pt.com.broker.client.nio.tests.Utils;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;

public class TestServerReconnect
extends ServerBaseTest {
    public void testHeartbeatWithReconnect() throws IOException, InterruptedException, TimeoutException, ExecutionException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.skipTest(Utils.isAndroid())) {
            return;
        }
        if (this.skipTest(!this.userHasPermissions())) {
            return;
        }
        List<SocketServer> servers = this.getServers();
        BrokerClient bk = new BrokerClient(NetProtocolType.JSON);
        HostContainer container = bk.getHosts();
        for (SocketServer server : servers) {
            HostInfo host = new HostInfo("127.0.0.1", server.getPort());
            host.setConnectTimeout(2000);
            host.setReaderIdleTime(4000L);
            host.setWriterIdleTime(2000L);
            bk.addServer(host);
        }
        bk.connect();
        Thread.sleep(2000L);
        String name = "/teste/";
        System.out.println(name);
        bk.subscribe(name, NetAction.DestinationType.QUEUE, (BrokerListener)new NotificationListenerAdapter(){

            public boolean onMessage(NetNotification message, HostInfo host) {
                return true;
            }
        });
        List<SocketServer> random_servers = this.getRandomServers(servers);
        for (SocketServer s : random_servers) {
            if (!ipTables.blockPort(TestServerReconnect.currentChainName(), s.getPort())) {
                System.out.println("Error blocking port");
            }
            System.out.println("Blocking server: " + s.getPort());
        }
        System.out.println("------ sleeping-------");
        Thread.sleep(10000L);
        int blockedservers = random_servers.size();
        int connected_servers = container.getConnectedSize();
        System.out.println("Connected Servers: " + connected_servers);
        System.out.println("Blocked Servers: " + blockedservers);
        Assert.assertEquals((long)container.getHostsSize(), (long)(connected_servers + blockedservers));
        for (SocketServer s : random_servers) {
            if (!ipTables.removePortBlock(TestServerReconnect.currentChainName(), s.getPort())) {
                System.out.println("Error ublocking port");
            }
            System.out.println("Unblocking server: " + s.getPort());
        }
        Thread.sleep(10000L);
        connected_servers = container.getConnectedSize();
        System.out.println("Total Servers: " + servers.size());
        System.out.println("Connected Servers: " + connected_servers);
        Assert.assertEquals((long)container.getHostsSize(), (long)connected_servers);
        this.ShutDownServers(servers);
    }
}

