/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import pt.com.broker.client.BrokerProtocolHandler;
import pt.com.broker.client.HostInfo;

public abstract class BaseNetworkConnector {
    protected Socket client;
    protected DataInputStream rawInput = null;
    protected DataOutputStream rawOutput = null;
    protected SocketAddress socketAddress;
    protected String socketAddressLiteral;
    protected volatile boolean closed = true;
    private BrokerProtocolHandler protocolHandler;
    protected HostInfo hostInfo = null;
    private long connectionVersion;

    public BaseNetworkConnector(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public synchronized DataInputStream getInput() {
        return this.rawInput;
    }

    public synchronized DataOutputStream getOutput() {
        return this.rawOutput;
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        try {
            this.rawInput.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.rawOutput.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.getSocket().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized boolean isConnected() {
        return this.getSocket().isConnected();
    }

    public synchronized boolean isInputShutdown() {
        return this.getSocket().isInputShutdown();
    }

    public synchronized boolean isOutputShutdown() {
        return this.getSocket().isOutputShutdown();
    }

    public synchronized SocketAddress getInetAddress() {
        return this.socketAddress;
    }

    public synchronized String getAddress() {
        return this.socketAddressLiteral;
    }

    public synchronized Socket getSocket() {
        return this.client;
    }

    public synchronized HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setConnectionVersion(long connectionVersion) {
        this.connectionVersion = connectionVersion;
    }

    public synchronized long getConnectionVersion() {
        return this.connectionVersion;
    }

    public synchronized void connect() throws Throwable {
        if (this.hostInfo == null) {
            throw new Exception("NetworkConnector: Unable to connect - no host information available");
        }
        this.connect(this.hostInfo, 0L);
    }

    protected abstract void connect(HostInfo var1, long var2) throws Throwable;

    public void setProtocolHandler(BrokerProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public BrokerProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }
}

