/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BaseNetworkConnector;
import pt.com.broker.client.HostInfo;

public class NetworkConnector
extends BaseNetworkConnector {
    private static final Logger log = LoggerFactory.getLogger(NetworkConnector.class);

    public NetworkConnector(HostInfo hostInfo) {
        super(hostInfo);
    }

    @Override
    public synchronized void connect(HostInfo host, long connectionVersion) throws Throwable {
        try {
            log.debug("Trying to connect");
            this.setConnectionVersion(connectionVersion);
            this.hostInfo = host;
            this.client = new Socket();
            this.client.setReceiveBufferSize(262144);
            this.client.setSendBufferSize(262144);
            this.client.setSoLinger(true, 2);
            this.client.setSoTimeout(host.getReadTimeout());
            this.client.connect(new InetSocketAddress(host.getHostname(), host.getPort()), host.getConnectTimeout());
            this.rawOutput = new DataOutputStream(this.getSocket().getOutputStream());
            this.rawInput = new DataInputStream(this.getSocket().getInputStream());
            this.socketAddress = this.getSocket().getRemoteSocketAddress();
            this.socketAddressLiteral = this.socketAddress.toString();
            log.debug("Connection established: " + this.socketAddressLiteral);
            this.closed = false;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

