/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.auth.AuthInfo;
import pt.com.broker.auth.CredentialsProvider;
import pt.com.broker.client.AcceptRequest;
import pt.com.broker.client.BaseBrokerClient;
import pt.com.broker.client.BrokerProtocolHandler;
import pt.com.broker.client.HostInfo;
import pt.com.broker.client.SslNetworkConnector;
import pt.com.broker.client.messaging.PendingAcceptRequestsManager;
import pt.com.broker.client.utils.BlockingMessageAcceptedListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetAuthentication;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;

public final class SslBrokerClient
extends BaseBrokerClient {
    private static final Logger log = LoggerFactory.getLogger(SslBrokerClient.class);
    private volatile boolean requiresAuthentication = false;
    protected AuthInfo userCredentials;
    private final SSLContext sslContext;
    private CredentialsProvider credentialsProvider;

    public SslBrokerClient(String hostname, int portNumber) throws Throwable {
        this(hostname, portNumber, "BrokerClient", NetProtocolType.PROTOCOL_BUFFER);
    }

    public SslBrokerClient(String hostname, int portNumber, String appName, NetProtocolType ptype) throws Throwable {
        this(hostname, portNumber, appName, 15000, 0, ptype, SslBrokerClient.getDefaultSslContext());
    }

    public SslBrokerClient(String hostname, int portNumber, String appName, NetProtocolType ptype, SSLContext sslContext) throws Throwable {
        this(hostname, portNumber, appName, 15000, 0, ptype, sslContext);
    }

    public SslBrokerClient(String hostname, int portNumber, String appName, int connectTimeout, int readTimeout, NetProtocolType ptype, SSLContext sslContext) throws Throwable {
        super(hostname, portNumber, connectTimeout, readTimeout, appName, ptype);
        this.sslContext = sslContext;
        this.init();
    }

    public SslBrokerClient(Collection<HostInfo> hosts, String appName, NetProtocolType ptype) throws Throwable {
        this(hosts, appName, ptype, SslBrokerClient.getDefaultSslContext());
    }

    public SslBrokerClient(Collection<HostInfo> hosts, String appName, NetProtocolType ptype, SSLContext sslContext) throws Throwable {
        super(hosts, appName, ptype);
        this.sslContext = sslContext;
        this.init();
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateClient() throws Throwable {
        if (this.credentialsProvider == null) {
            throw new IllegalStateException("Mandatory Credential Provider missing.");
        }
        this.requiresAuthentication = true;
        this.setState(BaseBrokerClient.BrokerClientState.AUTH);
        this.userCredentials = this.credentialsProvider.getCredentials();
        NetAuthentication clientAuth = new NetAuthentication(this.userCredentials.getToken(), this.userCredentials.getUserAuthenticationType());
        if (this.userCredentials.getRoles() != null && this.userCredentials.getRoles().size() != 0) {
            clientAuth.setRoles(this.userCredentials.getRoles());
        }
        if (this.userCredentials.getUserId() != null) {
            clientAuth.setUserId(this.userCredentials.getUserId());
        }
        NetAction action = new NetAction(NetAction.ActionType.AUTH);
        action.setAuthenticationMessage(clientAuth);
        NetMessage msg = new NetMessage(action);
        Object syncObj = new Object();
        BlockingMessageAcceptedListener acceptedListener = new BlockingMessageAcceptedListener(syncObj);
        String actionId = RandomStringUtils.randomAlphabetic((int)25);
        clientAuth.setActionId(actionId);
        AcceptRequest acceptRequest = new AcceptRequest(actionId, acceptedListener, 10000L);
        PendingAcceptRequestsManager.addAcceptRequest(acceptRequest);
        this.getNetHandler().sendMessage(msg);
        Object object = syncObj;
        synchronized (object) {
            syncObj.wait();
        }
        if (acceptedListener.wasFailure()) {
            log.error(String.format("Authentication failed: %s", acceptedListener.getFault().getMessage()));
            this.setState(BaseBrokerClient.BrokerClientState.OK);
            PendingAcceptRequestsManager.removeRequest(actionId);
            return false;
        }
        if (acceptedListener.wasTimeout()) {
            log.warn("Authentication failed by timeout.");
            PendingAcceptRequestsManager.removeRequest(actionId);
            this.setState(BaseBrokerClient.BrokerClientState.OK);
            return false;
        }
        this.setState(BaseBrokerClient.BrokerClientState.OK);
        return true;
    }

    public boolean isAuthenticationRequired() {
        return this.requiresAuthentication;
    }

    public SSLSession getSSLSession() {
        return ((SslNetworkConnector)this.getNetHandler().getConnector()).getSSLSession();
    }

    @Override
    protected BrokerProtocolHandler getBrokerProtocolHandler() throws Throwable {
        SslNetworkConnector networkConnector = new SslNetworkConnector(this.getHostInfo(), this.sslContext);
        BrokerProtocolHandler brokerProtocolHandler = new BrokerProtocolHandler(this, this.getProtocolType(), networkConnector, this.isOldFramming());
        networkConnector.setProtocolHandler(brokerProtocolHandler);
        return brokerProtocolHandler;
    }

    private static SSLContext getDefaultSslContext() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSLv3");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

