/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.codec.xml.SoapBindingSerializer;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetPublish;

public class UdpClient {
    private static final Logger log = LoggerFactory.getLogger(UdpClient.class);
    private final BindingSerializer serializer;
    private final short proto_type = 1;
    private final String hostname;
    private final boolean isOldFramming;
    private final int udpPort;

    public UdpClient(String hostname, int udpPort) {
        this(hostname, udpPort, false);
    }

    public UdpClient(String hostname, int udpPort, boolean isOldFramming) {
        this.hostname = hostname;
        this.isOldFramming = isOldFramming;
        this.udpPort = udpPort;
        this.serializer = isOldFramming ? new SoapBindingSerializer() : new ProtoBufBindingSerializer();
    }

    public void publish(NetPublish message) throws InvalidParameterException {
        if (message.getActionId() != null) {
            throw new InvalidParameterException("Messages published over UDP are not allowed to carry a message identifier.");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        NetAction action = new NetAction(NetAction.ActionType.PUBLISH);
        action.setPublishMessage(message);
        NetMessage netMessage = new NetMessage(action);
        try {
            if (this.isOldFramming) {
                byte[] marshaledMessage = this.marshalMessage(netMessage);
                out.write(marshaledMessage);
            } else {
                this.encode(netMessage, out);
            }
            out.flush();
            out.close();
            InetAddress inet = InetAddress.getByName(this.hostname);
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(5000);
            byte[] msgData = stream.toByteArray();
            DatagramPacket packet = new DatagramPacket(msgData, msgData.length, inet, this.udpPort);
            socket.send(packet);
            socket.close();
        }
        catch (Throwable t) {
            log.error("Error processing UDP message", t);
            throw new RuntimeException(t);
        }
    }

    public void encode(NetMessage message, DataOutputStream out) throws IOException {
        byte[] marshaledMsg = this.marshalMessage(message);
        if (!this.isOldFramming) {
            int protocolType = 1;
            int protocolVersion = 0;
            out.writeShort(protocolType);
            out.writeShort(protocolVersion);
        }
        out.writeInt(marshaledMsg.length);
        out.write(marshaledMsg);
    }

    public byte[] marshalMessage(NetMessage message) throws IOException {
        byte[] marshaledMsg = this.serializer.marshal(message);
        return marshaledMsg;
    }
}

