/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.caudexorigo.concurrent.CustomExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.AcceptRequest;
import pt.com.broker.types.NetFault;

public class PendingAcceptRequestsManager {
    private static final Logger log = LoggerFactory.getLogger(PendingAcceptRequestsManager.class);
    private static final ScheduledExecutorService shed_exec = CustomExecutors.newScheduledThreadPool((int)1, (String)"Pendig Accept Janitor");
    private static Map<String, AcceptRequest> requests = new HashMap<String, AcceptRequest>();
    private static Map<Long, String> timeouts = new TreeMap<Long, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAcceptRequest(AcceptRequest request) {
        if (request.getActionId() == null) {
            return;
        }
        Map<String, AcceptRequest> map = requests;
        synchronized (map) {
            if (requests.containsKey(request.getActionId())) {
                throw new IllegalArgumentException("Accept request wiht the same ActionId already exists");
            }
            requests.put(request.getActionId(), request);
            timeouts.put(new Long(System.currentTimeMillis() + request.getTimeoutDelta()), request.getActionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean messageFailed(NetFault fault) {
        AcceptRequest request = null;
        Map<String, AcceptRequest> map = requests;
        synchronized (map) {
            request = requests.get(fault.getActionId());
            if (request == null) {
                return false;
            }
            PendingAcceptRequestsManager.removeRequest(fault.getActionId());
        }
        request.getListner().messageFailed(fault);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRequest(String actionId) {
        Map<String, AcceptRequest> map = requests;
        synchronized (map) {
            requests.remove(actionId);
            for (Map.Entry<Long, String> entry : timeouts.entrySet()) {
                if (!entry.getValue().equals(actionId)) continue;
                timeouts.remove(entry.getKey());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptedMessageReceived(String actionId) {
        AcceptRequest request = null;
        Map<String, AcceptRequest> map = requests;
        synchronized (map) {
            request = requests.get(actionId);
            if (request == null) {
                log.error("Received unexpected action id: " + actionId);
                return;
            }
            PendingAcceptRequestsManager.removeRequest(actionId);
        }
        request.getListner().messageAccepted(actionId);
    }

    private static void onTimeout(AcceptRequest request) {
        request.getListner().messageTimedout(request.getActionId());
    }

    static {
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean deletedSomeEntry;
                    long currentTime = System.currentTimeMillis();
                    do {
                        deletedSomeEntry = false;
                        AcceptRequest request = null;
                        Map map = requests;
                        synchronized (map) {
                            for (Map.Entry entry : timeouts.entrySet()) {
                                if ((Long)entry.getKey() > currentTime) continue;
                                request = (AcceptRequest)requests.get(entry.getValue());
                                requests.remove(entry.getValue());
                                timeouts.remove(entry.getKey());
                                deletedSomeEntry = true;
                                log.warn("Accept Request with action id " + request.getActionId() + " timedout.");
                                break;
                            }
                        }
                        if (request == null) continue;
                        PendingAcceptRequestsManager.onTimeout(request);
                    } while (deletedSomeEntry);
                }
                catch (Throwable t) {
                    log.error("Jannitor timeout thread", t);
                }
            }
        };
        shed_exec.scheduleWithFixedDelay(command, 2000L, 500L, TimeUnit.MILLISECONDS);
    }
}

