/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.concurrent.Sleep;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.HostInfo;
import pt.com.broker.client.messaging.BrokerListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetSubscribe;

public class ConsumerWithFailover
implements BrokerListener {
    private final AtomicInteger counter = new AtomicInteger(0);
    private NetAction.DestinationType dtype;
    private String dname;
    private long waitTime;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        ConsumerWithFailover consumer = new ConsumerWithFailover();
        consumer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        consumer.dname = cargs.getDestination();
        consumer.waitTime = cargs.getDelay();
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>(2);
        hosts.add(new HostInfo("localhost", 3423));
        hosts.add(new HostInfo("localhost", 3323));
        BrokerClient bk = new BrokerClient(hosts, "tcp://mycompany.com/mysniffer");
        NetSubscribe subscribe = new NetSubscribe(consumer.dname, consumer.dtype);
        bk.addAsyncConsumer(subscribe, consumer);
        System.out.println("listening...");
    }

    @Override
    public boolean isAutoAck() {
        return this.dtype != NetAction.DestinationType.TOPIC;
    }

    @Override
    public void onMessage(NetNotification notification) {
        System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), this.counter.incrementAndGet());
        System.out.printf("Destination: '%s'%n", notification.getDestination());
        System.out.printf("Subscription: '%s'%n", notification.getSubscription());
        System.out.printf("Payload: '%s'%n", new String(notification.getMessage().getPayload()));
        if (this.waitTime > 0L) {
            Sleep.time((long)this.waitTime);
        }
    }
}

