/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import org.apache.commons.lang3.RandomStringUtils;
import org.caudexorigo.Shutdown;
import org.caudexorigo.cli.CliFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.sample.Producer;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetProtocolType;

public class DeferredDeliveryProducer {
    private static final Logger log = LoggerFactory.getLogger(Producer.class);
    private String host;
    private int port;
    private String dname;
    private long deferredDelivery;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        DeferredDeliveryProducer producer = new DeferredDeliveryProducer();
        producer.host = cargs.getHost();
        producer.port = cargs.getPort();
        producer.dname = cargs.getDestination();
        producer.deferredDelivery = cargs.getDelay() == 0L ? 1000L : cargs.getDelay();
        NetProtocolType protocolType = NetProtocolType.valueOf((String)cargs.getProtocolType());
        BrokerClient bk = new BrokerClient(producer.host, producer.port, "tcp://mycompany.com/mypublisher", protocolType);
        log.info("Sending message. Size: " + cargs.getMessageLength() + ". This message should be received in " + producer.deferredDelivery + "milliseconds.");
        String msg = RandomStringUtils.randomAlphanumeric((int)cargs.getMessageLength());
        NetBrokerMessage brokerMessage = new NetBrokerMessage(msg);
        brokerMessage.addHeader("DEFERRED_DELIVERY", "" + producer.deferredDelivery);
        bk.enqueueMessage(brokerMessage, producer.dname);
        bk.close();
        Shutdown.now();
    }
}

