/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.caudexorigo.Shutdown;
import org.caudexorigo.cli.CliFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.client.sample.Producer;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;

public class IntensiveProducer {
    private static final Logger log = LoggerFactory.getLogger(Producer.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    private String host;
    private int port;
    private NetAction.DestinationType dtype;
    private String dname;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        IntensiveProducer producer = new IntensiveProducer();
        producer.host = cargs.getHost();
        producer.port = cargs.getPort();
        producer.dtype = NetAction.DestinationType.valueOf((String)cargs.getDestinationType());
        producer.dname = cargs.getDestination();
        BrokerClient bk = new BrokerClient(producer.host, producer.port, "tcp://mycompany.com/mypublisher");
        Thread.sleep(1000L);
        producer.sendLoop(bk, cargs.getMessageLength());
        Shutdown.now();
    }

    private void sendLoop(BrokerClient bk, int messageLength) throws Throwable {
        String msg = RandomStringUtils.randomAlphanumeric((int)messageLength);
        NetBrokerMessage brokerMessage = new NetBrokerMessage(msg.getBytes("UTF-8"));
        long start = System.currentTimeMillis();
        for (int j = 0; j < 1000000; ++j) {
            if (this.dtype == NetAction.DestinationType.QUEUE) {
                bk.enqueueMessage(brokerMessage, this.dname);
            } else {
                bk.publishMessage(brokerMessage, this.dname);
            }
            if (this.counter.incrementAndGet() % 5000 != 0) continue;
            log.info(String.format("%s -> Send Message: %s", this.counter.get(), msg));
        }
        long stop = System.currentTimeMillis();
        double duration = (double)(stop - start) / 1000.0;
        log.info(String.format("Total time: %.2f sec.", duration));
    }
}

