/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.sample;

import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.caudexorigo.cli.CliFactory;
import org.caudexorigo.concurrent.Sleep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BrokerClient;
import pt.com.broker.client.CliArgs;
import pt.com.broker.types.NetNotification;

public class QueueSyncConsumer {
    private static final Logger log = LoggerFactory.getLogger(QueueSyncConsumer.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    private String host;
    private int port;
    private String dname;
    private long waitTime;
    private long timeout;
    private long reserveTime;

    public static void main(String[] args) throws Throwable {
        CliArgs cargs = (CliArgs)CliFactory.parseArguments(CliArgs.class, (String[])args);
        QueueSyncConsumer qsconsumer = new QueueSyncConsumer();
        qsconsumer.host = cargs.getHost();
        qsconsumer.port = cargs.getPort();
        qsconsumer.dname = cargs.getDestination();
        qsconsumer.waitTime = cargs.getDelay();
        qsconsumer.timeout = cargs.getPollTimeout();
        qsconsumer.reserveTime = cargs.getReserveTime();
        BrokerClient bk = new BrokerClient(qsconsumer.host, qsconsumer.port, "tcp://mycompany.com/mysniffer");
        qsconsumer.receiveLoop(bk);
    }

    private void receiveLoop(BrokerClient bk) throws Throwable {
        System.out.println("reserveTime= " + this.reserveTime);
        System.out.println("timeout= " + this.timeout);
        while (true) {
            NetNotification notification = null;
            if (this.timeout > 0L) {
                log.info("Send Poll request with timeout: {}ms", (Object)this.timeout);
                try {
                    notification = this.reserveTime == -1L ? bk.poll(this.dname, this.timeout, null) : bk.poll(this.dname, this.timeout, this.reserveTime, null);
                }
                catch (TimeoutException te) {
                    log.info("No message received in the specified timeout: {}ms", (Object)this.timeout);
                    notification = null;
                }
                if (notification == null) {
                    if (this.waitTime <= 0L) continue;
                    Sleep.time((long)this.waitTime);
                    continue;
                }
            } else {
                log.info("Send Poll request without timeout");
                notification = this.reserveTime == -1L ? bk.poll(this.dname, this.timeout, null) : bk.poll(this.dname, this.timeout, this.reserveTime, null);
            }
            if (notification == null) continue;
            System.out.printf("===========================     [%s]#%s   =================================%n", new Date(), this.counter.incrementAndGet());
            System.out.printf("Destination: '%s'%n", notification.getDestination());
            System.out.printf("Subscription: '%s'%n", notification.getSubscription());
            System.out.printf("Payload: '%s'%n", new String(notification.getMessage().getPayload()));
            if (this.waitTime > 0L) {
                log.info("Sleep for {}ms", (Object)this.waitTime);
                Sleep.time((long)this.waitTime);
            }
            bk.acknowledge(notification);
        }
    }
}

