/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.utils;

import java.util.ArrayList;
import java.util.Collection;

public class CircularContainer<T> {
    private ArrayList<T> innerContainer;
    private int index = -1;

    public CircularContainer() {
        this.innerContainer = new ArrayList();
    }

    public CircularContainer(int capacity) {
        this.innerContainer = new ArrayList(capacity);
    }

    public CircularContainer(Collection<T> elements) {
        this.innerContainer = new ArrayList<T>(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T value) {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            this.innerContainer.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T value) {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            this.innerContainer.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            this.index = -1;
            this.innerContainer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            return this.innerContainer.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peek() {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            if (this.index == -1) {
                return null;
            }
            if (this.innerContainer.isEmpty()) {
                return null;
            }
            if (this.index >= this.innerContainer.size()) {
                this.index = 0;
            }
            return this.innerContainer.get(this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        ArrayList<T> arrayList = this.innerContainer;
        synchronized (arrayList) {
            if (this.innerContainer.isEmpty()) {
                return null;
            }
            if (++this.index >= this.innerContainer.size()) {
                this.index = 0;
            }
            return this.innerContainer.get(this.index);
        }
    }
}

