/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty;

import java.nio.charset.Charset;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.http.netty.HttpDateFormat;
import org.caudexorigo.http.netty.HttpRequestWrapper;
import org.caudexorigo.http.netty.StaticFileAction;
import org.caudexorigo.http.netty.WebException;
import org.caudexorigo.http.netty.reporting.ResponseFormatter;
import org.caudexorigo.http.netty.reporting.StandardResponseFormatter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAction {
    private static Logger log = LoggerFactory.getLogger(HttpAction.class);
    private HttpRequest request = null;
    private ResponseFormatter defaultRspFmt = new StandardResponseFormatter(false);

    public abstract void service(ChannelHandlerContext var1, HttpRequest var2, HttpResponse var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void process(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        HttpRequest httpRequest = request = this.request != null ? this.request : request;
        if (this instanceof StaticFileAction) {
            try {
                this.service(ctx, request, response);
            }
            catch (Throwable ex) {
                this.handleError(ctx, request, response, ex);
                this.commitResponse(ctx, response, false);
            }
        } else {
            boolean is_keep_alive = HttpHeaders.isKeepAlive((HttpMessage)request);
            if (!is_keep_alive) {
                response.headers().set("Connection", (Object)"Close");
            }
            try {
                HttpRequestWrapper hrw = null;
                hrw = request instanceof HttpRequestWrapper ? (HttpRequestWrapper)request : new HttpRequestWrapper(request, this.getCharset());
                this.service(ctx, hrw, response);
            }
            catch (Throwable ex) {
                this.handleError(ctx, request, response, ex);
            }
            finally {
                this.commitResponse(ctx, response, is_keep_alive);
            }
        }
    }

    private void handleError(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, Throwable ex) {
        request = this.request != null ? this.request : request;
        response.headers().clear();
        Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)ex);
        if (ex instanceof WebException) {
            WebException w_ex = (WebException)ex;
            response.setStatus(HttpResponseStatus.valueOf((int)w_ex.getHttpStatusCode()));
        }
        if (log.isDebugEnabled()) {
            log.error(rootCause.getMessage(), rootCause);
        } else {
            log.error("http.netty.error: {}; path: {}", (Object)rootCause.getMessage(), (Object)request.getUri());
        }
        this.writeStandardResponse(ctx, request, response, rootCause);
    }

    private void commitResponse(ChannelHandlerContext ctx, HttpResponse response, boolean is_keep_alive) {
        response.headers().set("Date", (Object)HttpDateFormat.getCurrentHttpDate());
        response.headers().set("Content-Length", (Object)String.valueOf(response.getContent().writerIndex()));
        Channel channel = ctx.getChannel();
        ChannelFuture future = channel.write((Object)response);
        if (!is_keep_alive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void writeStandardResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, Throwable rootCause) {
        request = this.request != null ? this.request : request;
        ResponseFormatter rspFrm = this.getResponseFormatter();
        if (rootCause != null) {
            try {
                if (response.getStatus().getCode() < 400) {
                    response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
                rspFrm.formatResponse(ctx, request, response, rootCause);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public Charset getCharset() {
        return null;
    }

    protected ResponseFormatter getResponseFormatter() {
        return this.defaultRspFmt;
    }
}

