/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty;

import java.io.FileNotFoundException;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.http.netty.DefaultObserver;
import org.caudexorigo.http.netty.ErrorAction;
import org.caudexorigo.http.netty.HttpAction;
import org.caudexorigo.http.netty.RequestObserver;
import org.caudexorigo.http.netty.RequestRouter;
import org.caudexorigo.http.netty.WebException;
import org.caudexorigo.http.netty.reporting.ResponseFormatter;
import org.caudexorigo.http.netty.reporting.StandardResponseFormatter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProtocolHandler
extends SimpleChannelUpstreamHandler {
    private static Logger log = LoggerFactory.getLogger(HttpProtocolHandler.class);
    private final ResponseFormatter _rspFmt;
    private final RequestRouter _requestMapper;
    private final RequestObserver _requestObserver;

    public HttpProtocolHandler(RequestRouter requestMapper) {
        this._requestMapper = requestMapper;
        this._rspFmt = new StandardResponseFormatter(false);
        this._requestObserver = new DefaultObserver();
    }

    public HttpProtocolHandler(RequestRouter requestMapper, RequestObserver customObserver, ResponseFormatter customResponseFormtter) {
        this._requestMapper = requestMapper;
        this._rspFmt = customResponseFormtter == null ? new StandardResponseFormatter(false) : customResponseFormtter;
        this._requestObserver = customObserver == null ? new DefaultObserver() : customObserver;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        ch.close();
        if (log.isDebugEnabled()) {
            Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)e.getCause());
            log.debug(rootCause.getMessage(), rootCause);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        Channel ch = e.getChannel();
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)ch), (Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                ctx.setAttachment((Object)new DefaultHttpRequest(HttpVersion.HTTP_1_1, req.getMethod(), req.getUri()));
            }
            this.handleHttpRequest(ctx, req);
        } else if (msg instanceof DefaultHttpChunk) {
            DefaultHttpChunk req = (DefaultHttpChunk)msg;
            Object a = ctx.getAttachment();
            if (a != null && a instanceof DefaultHttpRequest) {
                DefaultHttpRequest real_request = (DefaultHttpRequest)a;
                real_request.setContent(req.getContent());
                this.handleHttpRequest(ctx, (HttpRequest)real_request);
                ctx.setAttachment(null);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid Object type received by HttpHandler: '%s'", msg.getClass().getCanonicalName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        block8: {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                HttpAction action = this._requestMapper.map(ctx, request);
                this.observeBegin(ctx, request, (HttpResponse)response);
                if (action != null) {
                    action.process(ctx, request, (HttpResponse)response);
                    break block8;
                }
                throw new WebException(new FileNotFoundException(), HttpResponseStatus.NOT_FOUND.getCode());
            }
            catch (Throwable t) {
                ErrorAction errorAction;
                if (t instanceof WebException) {
                    WebException we = (WebException)t;
                    errorAction = new ErrorAction(we, this._rspFmt);
                } else {
                    errorAction = new ErrorAction(new WebException(t, HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode()), this._rspFmt);
                }
                errorAction.process(ctx, request, (HttpResponse)response);
            }
            finally {
                this.observeEnd(ctx, request, (HttpResponse)response);
            }
        }
    }

    private void observeBegin(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        try {
            this._requestObserver.begin(ctx, request, response);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    private void observeEnd(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        try {
            this._requestObserver.end(ctx, request, response);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
    }
}

