/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.CustomExecutors;
import org.caudexorigo.http.netty.DefaultObserver;
import org.caudexorigo.http.netty.HttpProtocolHandler;
import org.caudexorigo.http.netty.HttpSslContext;
import org.caudexorigo.http.netty.RequestObserver;
import org.caudexorigo.http.netty.RequestRouter;
import org.caudexorigo.http.netty.reporting.ResponseFormatter;
import org.caudexorigo.http.netty.reporting.StandardResponseFormatter;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer {
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final int DEFAULT_PORT = 8080;
    private static Logger log = LoggerFactory.getLogger(NettyHttpServer.class);
    private Executor _bossExecutor;
    private String _host;
    private RequestRouter _mapper;
    private RequestObserver _requestObserver;
    private ResponseFormatter _rspFmt;
    private int _port;
    private Executor _workerExecutor;
    private final boolean _is_compression_enabled;

    public NettyHttpServer() {
        this(DEFAULT_HOST, 8080, false);
    }

    public NettyHttpServer(String host, int port) {
        this(host, port, false);
    }

    public NettyHttpServer(String host, int port, boolean is_compression_enabled) {
        this._host = host;
        this._port = port;
        this._is_compression_enabled = is_compression_enabled;
    }

    public NettyHttpServer(String host, int port, boolean is_compression_enabled, Executor boss_executor, Executor worker_executor) {
        this(host, port, is_compression_enabled);
        this._bossExecutor = boss_executor;
        this._workerExecutor = worker_executor;
    }

    private synchronized Executor getBossThreadPool() {
        if (this._bossExecutor == null) {
            this._bossExecutor = CustomExecutors.newCachedThreadPool((String)"http-boss");
        }
        return this._bossExecutor;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public RequestRouter getRouter() {
        return this._mapper;
    }

    private Executor getWorkerThreadPool() {
        if (this._workerExecutor == null) {
            this._workerExecutor = CustomExecutors.newCachedThreadPool((String)"http-worker");
        }
        return this._workerExecutor;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setRouter(RequestRouter mapper) {
        this._mapper = mapper;
    }

    private ResponseFormatter getResponseFormtter() {
        if (this._rspFmt != null) {
            return this._rspFmt;
        }
        return new StandardResponseFormatter(false);
    }

    protected RequestObserver getRequestObserver() {
        if (this._requestObserver != null) {
            return this._requestObserver;
        }
        return new DefaultObserver();
    }

    public void setRequestObserver(RequestObserver requestObserver) {
        this._requestObserver = requestObserver;
    }

    public void setResponseFormtter(ResponseFormatter rspFmt) {
        this._rspFmt = rspFmt;
    }

    public synchronized void start() {
        log.info("Starting Httpd");
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(this.getBossThreadPool(), this.getWorkerThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        ChannelPipelineFactory pf = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                try {
                    ChannelPipeline pipeline = Channels.pipeline();
                    pipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 262144));
                    pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                    if (NettyHttpServer.this._is_compression_enabled) {
                        pipeline.addLast("http-compression", (ChannelHandler)new HttpContentCompressor());
                    }
                    pipeline.addLast("http-handler", (ChannelHandler)new HttpProtocolHandler(NettyHttpServer.this._mapper, NettyHttpServer.this.getRequestObserver(), NettyHttpServer.this.getResponseFormtter()));
                    return pipeline;
                }
                catch (Throwable t) {
                    Shutdown.now((Throwable)t);
                    return null;
                }
            }
        };
        this.setupBootStrap(bootstrap, pf);
        try {
            InetSocketAddress inet = new InetSocketAddress(this.getHost(), this.getPort());
            bootstrap.bind((SocketAddress)inet);
            log.info("Httpd started. Listening on port: {}", (Object)inet.toString());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public synchronized void startSsl(HttpSslContext http_ssl_ctx) {
        SSLContext sslContext;
        log.info("Starting Httpd - SSL");
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(this.getBossThreadPool(), this.getWorkerThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        try {
            sslContext = http_ssl_ctx.getSSLContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ChannelPipelineFactory pf = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                try {
                    ChannelPipeline pipeline = Channels.pipeline();
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    SslHandler sslHandler = new SslHandler(sslEngine);
                    HttpRequestDecoder httpRequestDecoder = new HttpRequestDecoder(4096, 8192, 262144);
                    HttpResponseEncoder httpResponseEncoder = new HttpResponseEncoder();
                    HttpProtocolHandler http_handler = new HttpProtocolHandler(NettyHttpServer.this._mapper, NettyHttpServer.this.getRequestObserver(), NettyHttpServer.this.getResponseFormtter());
                    pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                    pipeline.addLast("http-decoder", (ChannelHandler)httpRequestDecoder);
                    pipeline.addLast("http-encoder", (ChannelHandler)httpResponseEncoder);
                    pipeline.addLast("http-handler", (ChannelHandler)http_handler);
                    return pipeline;
                }
                catch (Throwable t) {
                    Shutdown.now((Throwable)t);
                    return null;
                }
            }
        };
        this.setupBootStrap(bootstrap, pf);
        try {
            InetSocketAddress inet = new InetSocketAddress(this.getHost(), http_ssl_ctx.getSslPort());
            bootstrap.bind((SocketAddress)inet);
            log.info("Httpd SSL started. Listening on port: {}", (Object)inet.toString());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void setupBootStrap(ServerBootstrap bootstrap, ChannelPipelineFactory pf) {
        bootstrap.setPipelineFactory(pf);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setOption("child.receiveBufferSize", (Object)131072);
        bootstrap.setOption("child.sendBufferSize", (Object)131072);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("backlog", (Object)1024);
    }

    public void stop() {
        log.warn("pt.com.http.NettyHttpServer.stop() is not implemented");
    }
}

