/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.http.netty.HttpAction;
import org.caudexorigo.http.netty.HttpDateFormat;
import org.caudexorigo.http.netty.MimeTable;
import org.caudexorigo.http.netty.WebException;
import org.caudexorigo.http.netty.reporting.ResponseFormatter;
import org.caudexorigo.http.netty.reporting.StandardResponseFormatter;
import org.caudexorigo.text.UrlCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.ssl.SslHandler;

public class StaticFileAction
extends HttpAction {
    private final File rootDirectory;
    private final String rootDirectoryPath;
    private final long cacheAge;
    private ResponseFormatter rspFmt;

    public StaticFileAction(URI root_path) {
        this(root_path, new StandardResponseFormatter(false), 0L);
    }

    public StaticFileAction(URI root_path, ResponseFormatter rspFmt) {
        this(root_path, rspFmt, 0L);
    }

    public StaticFileAction(URI root_path, ResponseFormatter rspFmt, long cache_age) {
        this.rootDirectory = new File(root_path);
        this.rootDirectoryPath = this.rootDirectory.getAbsolutePath();
        this.rspFmt = rspFmt;
        this.cacheAge = cache_age;
        if (!this.rootDirectory.isDirectory() || !this.rootDirectory.canRead() || this.rootDirectory.isHidden()) {
            throw new IllegalArgumentException("Not a valid root directory");
        }
    }

    @Override
    public void service(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ChannelFuture writeFuture;
        Channel channel;
        this.validateRequest(request, response);
        File file = this.getFile(request, response);
        this.validateFile(response, file, request.getUri());
        String abs_path = this.getFileAbsolutePath(response, file);
        response.headers().set("Date", (Object)HttpDateFormat.getCurrentHttpDate());
        response.headers().set("Content-Length", (Object)Long.toString(file.length()));
        String ctype = MimeTable.getContentType(abs_path);
        if (StringUtils.isNotBlank((CharSequence)ctype)) {
            response.headers().set("Content-Type", (Object)ctype);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getContentEncoding())) {
            response.headers().set("Content-Encoding", (Object)this.getContentEncoding());
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        response.setStatus(HttpResponseStatus.OK);
        if (this.cacheAge > 0L) {
            response.headers().set("Cache-Control", (Object)String.format("max-age=%s", this.cacheAge));
            response.headers().set("Last-Modified", (Object)HttpDateFormat.getHttpDate(new Date(file.lastModified())));
        }
        boolean is_secure = (channel = ctx.getChannel()).getPipeline().get(SslHandler.class) != null;
        boolean is_keep_alive = HttpHeaders.isKeepAlive((HttpMessage)request);
        if (is_secure) {
            is_keep_alive = false;
        }
        if (is_keep_alive) {
            response.headers().set("Connection", (Object)"Keep-Alive");
        }
        channel.write((Object)response);
        try {
            if (is_secure) {
                int b;
                ChannelBuffer cb = ChannelBuffers.directBuffer((int)((int)raf.length()));
                while ((b = raf.read()) != -1) {
                    cb.writeByte(b);
                }
                writeFuture = channel.write((Object)cb);
                raf.close();
            } else {
                DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, raf.length());
                writeFuture = channel.write((Object)region);
                writeFuture.addListener(new ChannelFutureListener((FileRegion)region){
                    final /* synthetic */ FileRegion val$region;
                    {
                        this.val$region = fileRegion;
                    }

                    public void operationComplete(ChannelFuture cf) throws Exception {
                        this.val$region.releaseExternalResources();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!is_keep_alive) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    protected ResponseFormatter getResponseFormatter() {
        return this.rspFmt;
    }

    public String getContentEncoding() {
        return null;
    }

    protected String getFileAbsolutePath(HttpResponse response, File file) {
        String abs_path = file.getAbsolutePath();
        if (!file.getAbsolutePath().startsWith(this.rootDirectoryPath)) {
            response.setStatus(HttpResponseStatus.FORBIDDEN);
            throw new IllegalArgumentException("Forbidden");
        }
        return abs_path;
    }

    protected File getFile(HttpRequest request, HttpResponse response) {
        String path = this.sanitizePath(request.getUri());
        if (path == null) {
            response.setStatus(HttpResponseStatus.FORBIDDEN);
            throw new IllegalArgumentException("Forbidden");
        }
        File file = new File(path);
        return file;
    }

    protected void validateFile(HttpResponse response, File file, String path) {
        if (file.isHidden() || !file.exists()) {
            throw new WebException(new FileNotFoundException(String.format("File not found: '%s'", path)), HttpResponseStatus.NOT_FOUND.getCode());
        }
        if (!file.isFile()) {
            throw new WebException(new IllegalArgumentException("Forbidden"), HttpResponseStatus.FORBIDDEN.getCode());
        }
    }

    protected void validateRequest(HttpRequest request, HttpResponse response) {
        if (request.getMethod() != HttpMethod.GET) {
            throw new WebException(new IllegalArgumentException("Method not allowed"), HttpResponseStatus.METHOD_NOT_ALLOWED.getCode());
        }
        if (request.isChunked()) {
            throw new WebException(new IllegalArgumentException("Bad request"), HttpResponseStatus.BAD_REQUEST.getCode());
        }
    }

    private String sanitizePath(String spath) {
        String path = StringUtils.substringBefore((String)spath, (String)"?");
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        try {
            path = UrlCodec.decode((String)path, (String)"ISO-8859-1");
        }
        catch (Throwable e) {
            path = UrlCodec.decode((String)path, (String)"UTF-8");
        }
        path = path.replace('/', File.separatorChar);
        if (path.contains(File.separator + ".") || path.contains("." + File.separator) || path.startsWith(".") || path.endsWith(".")) {
            return null;
        }
        return this.rootDirectoryPath + File.separator + path;
    }
}

