/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty.reporting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.caudexorigo.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTemplates {
    private static Logger log = LoggerFactory.getLogger(ErrorTemplates.class);
    private static Map<Integer, String> templates;
    private static String DEFAULT_TEMPLATE;

    public static String getTemplate(int code) {
        String template = templates.get(code);
        return template != null ? template : DEFAULT_TEMPLATE;
    }

    public static void setTemplate(int code, String template) {
        templates.put(code, template);
    }

    public static void setTemplateFromFile(int code, String fileLocation) {
        try {
            String template = IOUtils.toString((InputStream)new FileInputStream(new File(fileLocation)));
            ErrorTemplates.setTemplate(code, template);
        }
        catch (Exception e) {
            log.error(String.format("Error trying to read file '%s' for code %s.", fileLocation, code));
        }
    }

    static {
        try {
            DEFAULT_TEMPLATE = IOUtils.toString((InputStream)ErrorTemplates.class.getResourceAsStream("std.html"));
        }
        catch (IOException e) {
            log.error("Failed to load error template", (Throwable)e);
            DEFAULT_TEMPLATE = "";
        }
        templates = new HashMap<Integer, String>();
    }
}

