/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty.reporting;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.http.netty.reporting.ErrorTemplates;
import org.caudexorigo.http.netty.reporting.MessageBody;
import org.caudexorigo.http.netty.reporting.ResponseFormatter;
import org.caudexorigo.io.UnsynchronizedStringWriter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardResponseFormatter
implements ResponseFormatter {
    private static Logger log = LoggerFactory.getLogger(StandardResponseFormatter.class);
    private final boolean showFullErrorInfo;

    public StandardResponseFormatter(boolean showFullErrorInfo) {
        this.showFullErrorInfo = showFullErrorInfo;
    }

    @Override
    public void formatResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        this.formatResponse(ctx, request, response, null);
    }

    @Override
    public void formatResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, Throwable error) {
        int rsp_code = response.getStatus().getCode();
        if (MessageBody.allow(rsp_code)) {
            try {
                String html = String.format(ErrorTemplates.getTemplate(response.getStatus().getCode()), response.getStatus().getCode(), response.getStatus().getReasonPhrase(), request.getMethod().toString(), this.getStackTrace(error, this.showFullErrorInfo));
                byte[] bytes = html.toString().getBytes("UTF-8");
                ChannelBuffer out = ChannelBuffers.wrappedBuffer((byte[])bytes);
                response.setContent(out);
                response.addHeader("Content-Type", (Object)"text/html");
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
    }

    public String getStackTrace(Throwable error, boolean fullInfo) {
        if (error != null) {
            if (fullInfo) {
                log.error(error.getMessage(), error);
                UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw);
                error.printStackTrace(pw);
                pw.flush();
                String emsg = sw.toString();
                return emsg;
            }
            return (String)StringUtils.defaultIfEmpty((CharSequence)error.getMessage(), (CharSequence)"N/A");
        }
        return "N/A";
    }
}

