/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.http.helloworld;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.caudexorigo.Shutdown;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.example.http.helloworld.HttpHelloWorldServerPipelineFactory;

public class HttpHelloWorldServer {
    private final int port;

    public HttpHelloWorldServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("backlog", (Object)1024);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpHelloWorldServerPipelineFactory());
        InetSocketAddress inet = new InetSocketAddress(this.port);
        bootstrap.bind((SocketAddress)inet);
        System.out.printf("Httpd started. Listening on: %s%n", inet.toString());
    }

    public static void main(String[] args) {
        try {
            int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
            new HttpHelloWorldServer(port).run();
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }
}

