/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.http.helloworld;

import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

@ChannelHandler.Sharable
public class HttpHelloWorldServerHandler
extends SimpleChannelUpstreamHandler {
    private static final byte[] CONTENT = "Hello World".getBytes();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        Channel ch = e.getChannel();
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)ch), (Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)req);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpHeaders hh = response.headers();
            response.setContent(ChannelBuffers.wrappedBuffer((byte[])CONTENT));
            hh.set("Content-Type", (Object)"text/plain");
            hh.set("Content-Length", (Object)CONTENT.length);
            if (!keepAlive) {
                ChannelFuture f = Channels.future((Channel)ch);
                f.addListener(ChannelFutureListener.CLOSE);
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)f, (Object)response);
            } else {
                hh.set("Connection", (Object)"keep-alive");
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)ch), (Object)response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getChannel().close();
    }
}

