/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.http.netty4.CacheAdapter;
import org.caudexorigo.http.netty4.CacheKey;
import org.caudexorigo.http.netty4.CacheKeyBuilder;
import org.caudexorigo.http.netty4.CompressionAdapter;
import org.caudexorigo.http.netty4.HelloWorldAction;
import org.caudexorigo.http.netty4.HttpAction;
import org.caudexorigo.http.netty4.RequestRouter;

public class DefaultRouter
implements RequestRouter {
    private final HttpAction hello = new HelloWorldAction();
    private final HttpAction gz_hello = new CompressionAdapter(this.hello);
    private final HttpAction gz_cached_hello = new CompressionAdapter(this.gz_hello);
    private final CacheKeyBuilder cacheKeyBuilder = new CacheKeyBuilder(){
        private static final String GZIP_ENCODING = "gzip";
        private static final String DEFLATE_ENCODING = "deflate";

        @Override
        public CacheKey build(ChannelHandlerContext ctx, FullHttpRequest request) {
            String path = StringUtils.substringBefore((String)request.getUri(), (String)"?");
            String accept_enconding = StringUtils.trimToEmpty((String)request.headers().get("Accept-Encoding"));
            boolean allows_gzip = StringUtils.containsIgnoreCase((CharSequence)accept_enconding, (CharSequence)GZIP_ENCODING);
            boolean allows_deflate = StringUtils.containsIgnoreCase((CharSequence)accept_enconding, (CharSequence)DEFLATE_ENCODING);
            String content_encoding = allows_gzip ? GZIP_ENCODING : (allows_deflate ? DEFLATE_ENCODING : "plain");
            return new CacheKey(60L, TimeUnit.MINUTES, path, content_encoding);
        }
    };
    private final HttpAction cached_hello = new CacheAdapter(this.hello, this.cacheKeyBuilder);

    @Override
    public HttpAction map(ChannelHandlerContext ctx, FullHttpRequest req) {
        if ("/hello".equals(req.getUri())) {
            return this.hello;
        }
        if ("/gz_hello".equals(req.getUri())) {
            return this.gz_hello;
        }
        if ("/gz_cached_hello".equals(req.getUri())) {
            return this.gz_cached_hello;
        }
        if ("/cached_hello".equals(req.getUri())) {
            return this.cached_hello;
        }
        return null;
    }
}

