/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.http.netty4.HttpDateFormat;
import org.caudexorigo.http.netty4.RequestObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAction {
    private static final CharSequence CONTENT_LENGTH_ENTITY = HttpHeaders.newEntity((String)"Content-Length");
    private static final CharSequence DATE_ENTITY = HttpHeaders.newEntity((String)"Date");
    private static Logger log = LoggerFactory.getLogger(HttpAction.class);

    public abstract void service(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);

    protected void process(ChannelHandlerContext ctx, FullHttpRequest request, RequestObserver requestObserver) {
        this.observeBegin(ctx, (HttpRequest)request, requestObserver);
        if (this.isZeroCopy()) {
            EmptyByteBuf buf = new EmptyByteBuf(ctx.alloc());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, (ByteBuf)buf);
            try {
                this.service(ctx, request, (FullHttpResponse)response);
            }
            catch (Throwable t) {
                if (response != null) {
                    ReferenceCountUtil.release((Object)response);
                }
                throw new RuntimeException(t);
            }
            this.observeEnd(ctx, (HttpRequest)request, (HttpResponse)response, requestObserver);
            ReferenceCountUtil.release((Object)response);
        } else {
            FullHttpResponse response = this.buildResponse(ctx);
            try {
                this.doProcess(ctx, request, response);
            }
            catch (Throwable t) {
                if (response != null) {
                    ReferenceCountUtil.release((Object)response);
                }
                throw new RuntimeException(t);
            }
            this.observeEnd(ctx, (HttpRequest)request, (HttpResponse)response, requestObserver);
        }
    }

    void doProcess(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        boolean is_keep_alive = HttpHeaders.isKeepAlive((HttpMessage)request);
        this.service(ctx, request, response);
        this.commitResponse(ctx, response, is_keep_alive);
    }

    protected FullHttpResponse buildResponse(ChannelHandlerContext ctx) {
        ByteBuf buf = ctx.alloc().buffer();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        return response;
    }

    protected boolean isZeroCopy() {
        return false;
    }

    void commitResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean is_keep_alive) {
        response.headers().set(CONTENT_LENGTH_ENTITY, (Object)String.valueOf(response.content().readableBytes()));
        response.headers().set(DATE_ENTITY, (Object)HttpDateFormat.getCurrentHttpDate());
        ChannelFuture future = ctx.writeAndFlush((Object)response);
        if (!is_keep_alive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected void observeBegin(ChannelHandlerContext ctx, HttpRequest request, RequestObserver requestObserver) {
        try {
            requestObserver.begin(ctx, request);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    protected void observeEnd(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, RequestObserver requestObserver) {
        try {
            requestObserver.end(ctx, request, response);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }
}

