/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.http.helloworld.HttpHelloWorldServerInitializer;
import org.apache.commons.lang3.StringUtils;

public class HttpHelloWorldServer {
    private final int port;

    public HttpHelloWorldServer(int port) {
        this.port = port;
    }

    public void run() throws Exception {
        if (Epoll.isAvailable()) {
            System.out.println("netty-transport: linux-epoll");
            this.doRun((EventLoopGroup)new EpollEventLoopGroup(), (EventLoopGroup)new EpollEventLoopGroup(), EpollServerSocketChannel.class);
        } else {
            System.out.println("netty-transport: nio");
            this.doRun((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup(), NioServerSocketChannel.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(EventLoopGroup bossGroup, EventLoopGroup workerGroup, Class<? extends ServerChannel> serverChannelClass) throws InterruptedException {
        try {
            String os_arch = System.getProperty("os.arch");
            boolean isARM = StringUtils.contains((CharSequence)os_arch, (CharSequence)"arm");
            ServerBootstrap b = new ServerBootstrap();
            if (isARM) {
                b.childOption(ChannelOption.ALLOCATOR, (Object)new UnpooledByteBufAllocator(false));
            } else {
                b.childOption(ChannelOption.ALLOCATOR, (Object)new PooledByteBufAllocator(true));
            }
            b.childOption(ChannelOption.MAX_MESSAGES_PER_READ, (Object)Integer.MAX_VALUE);
            b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
            b.option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)Integer.MAX_VALUE);
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            b.option(ChannelOption.SO_REUSEADDR, (Object)true);
            ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(serverChannelClass)).childHandler((ChannelHandler)new HttpHelloWorldServerInitializer());
            Channel ch = b.bind(this.port).sync().channel();
            System.out.printf("Httpd started. Listening on: %s%n", ch.localAddress().toString());
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8082;
        new HttpHelloWorldServer(port).run();
    }
}

