/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public class HttpHelloWorldServerHandler
extends ChannelInboundHandlerAdapter {
    private static final CharSequence CONTENT_LENGTH_ENTITY = HttpHeaders.newEntity((String)"Content-Length");
    private static final CharSequence CONNECTION_ENTITY = HttpHeaders.newEntity((String)"Connection");
    private static final CharSequence CONTENT_TYPE_ENTITY = HttpHeaders.newEntity((String)"Content-Type");
    private static final CharSequence KEEP_ALIVE = HttpHeaders.newEntity((String)"keep-alive");
    private static final CharSequence TEXT_PLAIN = HttpHeaders.newEntity((String)"text/plain");
    private static final byte[] CONTENT = "Hello World".getBytes();
    private static final ByteBuf CONTENT_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().writeBytes(CONTENT));
    private static final CharSequence contentLength = HttpHeaders.newEntity((String)String.valueOf(CONTENT_BUFFER.readableBytes()));

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, CONTENT_BUFFER.duplicate(), false);
            HttpHeaders hh = response.headers();
            hh.set(CONTENT_TYPE_ENTITY, (Object)TEXT_PLAIN);
            hh.set(CONTENT_LENGTH_ENTITY, (Object)contentLength);
            if (!keepAlive) {
                ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                hh.set(CONNECTION_ENTITY, (Object)KEEP_ALIVE);
                ctx.write((Object)response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
    }
}

