/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.io.File;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.http.netty4.MimeTable;
import org.caudexorigo.http.netty4.StaticFileAction;

public class GzipStaticFileAction
extends StaticFileAction {
    private static final String GZIP_ENCODING = "gzip";

    public GzipStaticFileAction(URI rootPath) {
        super(rootPath);
    }

    public GzipStaticFileAction(URI rootPath, long cacheDuration) {
        super(rootPath, cacheDuration);
    }

    @Override
    protected File getFile(FullHttpRequest request) {
        String original_req_path = StringUtils.substringBefore((String)request.getUri(), (String)"?");
        try {
            if (this.allowsGzip((HttpRequest)request)) {
                String req_path = original_req_path.concat(".gz");
                return this.getFile(req_path);
            }
            return this.getFile(original_req_path);
        }
        catch (Throwable t) {
            return this.getFile(original_req_path);
        }
    }

    @Override
    public String getContentEncoding(HttpRequest request, File file) {
        boolean isGzipFile = file.getPath().endsWith(".gz");
        if (this.allowsGzip(request) && isGzipFile) {
            return GZIP_ENCODING;
        }
        return null;
    }

    @Override
    protected CharSequence getMimeType(HttpRequest request, File file) {
        String original_req_path = StringUtils.substringBefore((String)request.getUri(), (String)"?");
        return MimeTable.getContentType(original_req_path);
    }

    private boolean allowsGzip(HttpRequest request) {
        String accept_enconding = request.headers().get("Accept-Encoding");
        return StringUtils.containsIgnoreCase((CharSequence)accept_enconding, (CharSequence)GZIP_ENCODING);
    }
}

