/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.concurrent.FastThreadLocal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HttpDateFormat {
    private static final int DEFAULT_GRANULARITY = 1000;
    private static int granularity = 1000;
    private static final String DEFAULT_TIME_ZONE_NAME = "GMT";
    private static final FastThreadLocal<HttpDateFormat> FORMAT_LOCAL = new FastThreadLocal<HttpDateFormat>(){

        protected HttpDateFormat initialValue() {
            return new HttpDateFormat();
        }
    };
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private long timeLastGenerated;
    private CharSequence currentHTTPDate;

    private HttpDateFormat() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIME_ZONE_NAME));
    }

    public static CharSequence getCurrentHttpDate() {
        return ((HttpDateFormat)FORMAT_LOCAL.get()).getCurrentDate();
    }

    public static String getHttpDate(Date d) {
        return ((HttpDateFormat)FORMAT_LOCAL.get()).getDate(d);
    }

    private CharSequence getCurrentDate() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timeLastGenerated > (long)granularity) {
            this.timeLastGenerated = currentTime;
            this.currentHTTPDate = HttpHeaders.newEntity((String)this.dateFormat.format(new Date(currentTime)));
        }
        return this.currentHTTPDate;
    }

    private String getDate(Date d) {
        return this.dateFormat.format(d);
    }
}

