/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.caudexorigo.http.netty4.HttpProtocolHandler;

public class NettySslHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final HttpProtocolHandler handler;
    private SSLContext ssl_context;

    public NettySslHttpServerInitializer(SSLContext ssl_context, HttpProtocolHandler handler) {
        this.ssl_context = ssl_context;
        this.handler = handler;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SSLEngine sslEngine = this.ssl_context.createSSLEngine();
        sslEngine.setUseClientMode(false);
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)this.handler);
    }
}

