/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.text.UrlCodec;

public class ParameterDecoder {
    private static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final Pattern splitter = Pattern.compile(",|;");
    private Charset charset;
    private String charsetName;
    private Map<String, List<String>> parameters;
    private String path;
    private String queryString;
    private FullHttpRequest request;

    public ParameterDecoder(FullHttpRequest request) {
        this(request, null);
    }

    public ParameterDecoder(FullHttpRequest request, Charset charset) {
        this.request = request;
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        this.charsetName = this.charset.displayName();
    }

    private void addParameter(String name, String value) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    public String coalesce(String ... values) {
        for (String v : values) {
            if (!StringUtils.isNotBlank((CharSequence)v)) continue;
            return v;
        }
        return null;
    }

    public String getCharacterEncoding() {
        return this.charsetName;
    }

    public List<String> getMultiParameters(ParameterDecoder pdec, String ... param_names) {
        ArrayList<String> lst_target = new ArrayList<String>();
        for (String param_name : param_names) {
            List<String> tmp_lst = pdec.getParameters(param_name);
            if (tmp_lst == null) continue;
            for (String tmp_s : tmp_lst) {
                String[] tmp_arr_s;
                for (String ts : tmp_arr_s = splitter.split(tmp_s)) {
                    String g = StringUtils.trimToNull((String)ts);
                    if (g == null) continue;
                    lst_target.add(g);
                }
            }
        }
        return lst_target;
    }

    public String getParameter(String name) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public Map<String, List<String>> getParameters() {
        this.initParameters();
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<String> getParameters(String name) {
        this.initParameters();
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = StringUtils.substringBefore((String)this.request.getUri(), (String)"?");
        }
        return this.path;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            this.queryString = StringUtils.substringAfter((String)this.request.getUri(), (String)"?");
        }
        return this.queryString;
    }

    public String getUri() {
        return this.request.getUri();
    }

    private void initParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, List<String>>();
            this.setParameters(this.getQueryString());
            String content_type = this.request.headers().get("Content-Type");
            if (this.request.getMethod().equals((Object)HttpMethod.POST) && StringUtils.contains((CharSequence)content_type, (CharSequence)X_WWW_FORM_URLENCODED) && HttpHeaders.getContentLength((HttpMessage)this.request) > 0L) {
                if (StringUtils.contains((CharSequence)content_type, (CharSequence)UTF8_CHARSET_NAME)) {
                    this.charset = UTF8_CHARSET;
                }
                this.setParameters(this.request.content().toString(this.charset));
            }
        }
    }

    public void setCharacterEncoding(String encoding) {
        this.charset = Charset.forName(encoding);
        this.charsetName = this.charset.displayName();
    }

    private void setParameters(String parameters) {
        try {
            this.setParameters(parameters, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(this.charsetName + " decoder must be provided by JDK.");
        }
    }

    private void setParameters(String parameters, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)parameters)) {
            return;
        }
        int pos = 0;
        while (pos < parameters.length()) {
            String value;
            int ampPos = parameters.indexOf(38, pos);
            if (ampPos < 0) {
                value = parameters.substring(pos);
                ampPos = parameters.length();
            } else {
                value = parameters.substring(pos, ampPos);
            }
            int equalPos = value.indexOf(61);
            if (equalPos < 0) {
                this.addParameter(UrlCodec.decode((String)value, (String)encoding), "");
            } else {
                this.addParameter(UrlCodec.decode((String)value.substring(0, equalPos), (String)encoding), UrlCodec.decode((String)value.substring(equalPos + 1), (String)encoding));
            }
            pos = ampPos + 1;
        }
    }

    public boolean tryParse(String parameter, boolean default_value) {
        try {
            if (StringUtils.isBlank((CharSequence)parameter)) {
                return default_value;
            }
            return Boolean.parseBoolean(parameter);
        }
        catch (Throwable e) {
            return default_value;
        }
    }

    public double tryParse(String parameter, double default_value) {
        try {
            if (StringUtils.isBlank((CharSequence)parameter)) {
                return default_value;
            }
            return Double.parseDouble(parameter);
        }
        catch (Throwable e) {
            return default_value;
        }
    }

    public int tryParse(String parameter, int default_value) {
        try {
            if (StringUtils.isBlank((CharSequence)parameter)) {
                return default_value;
            }
            return Integer.parseInt(parameter);
        }
        catch (Throwable e) {
            return default_value;
        }
    }

    public long tryParse(String parameter, long default_value) {
        try {
            if (StringUtils.isBlank((CharSequence)parameter)) {
                return default_value;
            }
            return Long.parseLong(parameter);
        }
        catch (Throwable e) {
            return default_value;
        }
    }
}

