/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Files;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.http.netty4.HttpAction;
import org.caudexorigo.http.netty4.HttpDateFormat;
import org.caudexorigo.http.netty4.MimeTable;
import org.caudexorigo.http.netty4.WebException;
import org.caudexorigo.text.UrlCodec;

public class StaticFileAction
extends HttpAction {
    private final File rootDirectory;
    private final String rootDirectoryPath;
    private final long cacheDuration;

    public StaticFileAction(URI rootPath) {
        this(rootPath, 0L);
    }

    public StaticFileAction(URI rootPath, long cacheDuration) {
        this.rootDirectory = new File(rootPath);
        this.rootDirectoryPath = this.rootDirectory.getAbsolutePath();
        this.cacheDuration = cacheDuration;
        if (!this.rootDirectory.isDirectory() || !this.rootDirectory.canRead() || this.rootDirectory.isHidden()) {
            throw new IllegalArgumentException("Not a valid root directory");
        }
    }

    @Override
    public void service(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse rsp) {
        String contentEncoding;
        this.validateRequest(request);
        File file = this.getFile(request);
        long clen = file.length();
        DefaultHttpResponse response = new DefaultHttpResponse(rsp.getProtocolVersion(), rsp.getStatus(), false);
        Set previousHeaders = rsp.headers().names();
        for (String hname : previousHeaders) {
            response.headers().add(hname, (Object)rsp.headers().get(hname));
        }
        CharSequence ctype = this.getMimeType((HttpRequest)request, file);
        if (StringUtils.isNotBlank((CharSequence)ctype)) {
            response.headers().set("Content-Type", (Object)ctype);
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        response.setStatus(HttpResponseStatus.OK);
        response.headers().set("Date", (Object)HttpDateFormat.getCurrentHttpDate());
        if (this.cacheDuration > 0L) {
            response.headers().set("Cache-Control", (Object)String.format("max-age=%s", this.cacheDuration));
            response.headers().set("Last-Modified", (Object)HttpDateFormat.getHttpDate(new Date(file.lastModified())));
            response.headers().set("Vary", (Object)"Accept-Encoding");
        }
        if (StringUtils.isNotBlank((CharSequence)(contentEncoding = this.getContentEncoding((HttpRequest)request, file)))) {
            response.headers().set("Content-Encoding", (Object)contentEncoding);
        }
        boolean is_keep_alive = HttpHeaders.isKeepAlive((HttpMessage)request);
        try {
            if (request.getMethod() == HttpMethod.GET) {
                boolean useSsl;
                response.headers().set("Content-Length", (Object)Long.toString(clen));
                rsp.headers().set(response.headers());
                rsp.setStatus(rsp.getStatus());
                ctx.write((Object)response);
                boolean bl = useSsl = ctx.pipeline().get(SslHandler.class) != null;
                if (useSsl) {
                    is_keep_alive = false;
                    ctx.write((Object)new ChunkedFile(raf, 0L, clen, 16384), ctx.voidPromise());
                } else {
                    ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, clen), ctx.voidPromise());
                }
            } else if (request.getMethod() == HttpMethod.HEAD) {
                response.headers().set("Content-Length", (Object)"0");
                rsp.headers().set(response.headers());
                rsp.setStatus(rsp.getStatus());
                ctx.write((Object)response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!is_keep_alive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected CharSequence getMimeType(HttpRequest request, File file) {
        try {
            String ctype = Files.probeContentType(file.toPath());
            if (StringUtils.isNotBlank((CharSequence)ctype)) {
                return ctype;
            }
            return MimeTable.getContentType(file.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getContentEncoding(HttpRequest req, File file) {
        return null;
    }

    protected String getFileAbsolutePath(File file) {
        String abs_path = file.getAbsolutePath();
        if (!file.getAbsolutePath().startsWith(this.rootDirectoryPath)) {
            throw new WebException(new IllegalArgumentException("Forbidden"), HttpResponseStatus.FORBIDDEN.code());
        }
        return abs_path;
    }

    protected File getFile(FullHttpRequest request) {
        String req_path = StringUtils.substringBefore((String)request.getUri(), (String)"?");
        return this.getFile(req_path);
    }

    protected File getFile(String req_path) {
        String fs_path = this.sanitizePath(req_path);
        if (fs_path == null) {
            throw new WebException(new IllegalArgumentException("Forbidden"), HttpResponseStatus.FORBIDDEN.code());
        }
        File file = new File(fs_path);
        this.validateFile(file, req_path);
        return file;
    }

    protected void validateFile(File file, String path) {
        if (file.isHidden() || !file.exists()) {
            throw new WebException(new FileNotFoundException(String.format("File not found: '%s'", path)), HttpResponseStatus.NOT_FOUND.code());
        }
        if (!file.isFile()) {
            throw new WebException(new IllegalArgumentException(), HttpResponseStatus.FORBIDDEN.code());
        }
    }

    protected void validateRequest(FullHttpRequest request) {
        if (request.getMethod() != HttpMethod.GET && request.getMethod() != HttpMethod.HEAD) {
            throw new WebException(new IllegalArgumentException("Method not allowed"), HttpResponseStatus.METHOD_NOT_ALLOWED.code());
        }
        if (HttpHeaders.isTransferEncodingChunked((HttpMessage)request)) {
            throw new WebException(new IllegalArgumentException("Bad request"), HttpResponseStatus.BAD_REQUEST.code());
        }
    }

    private String sanitizePath(String req_path) {
        if (StringUtils.isBlank((CharSequence)req_path)) {
            return null;
        }
        try {
            req_path = UrlCodec.decode((String)req_path, (String)"ISO-8859-1");
        }
        catch (Throwable e) {
            req_path = UrlCodec.decode((String)req_path, (String)"UTF-8");
        }
        req_path = req_path.replace('/', File.separatorChar);
        if (req_path.contains(File.separator + ".") || req_path.contains("." + File.separator) || req_path.startsWith(".") || req_path.endsWith(".")) {
            return null;
        }
        return this.rootDirectoryPath + File.separator + req_path;
    }

    @Override
    protected boolean isZeroCopy() {
        return true;
    }
}

