/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.http.netty4.reporting;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.http.netty4.reporting.ErrorTemplates;
import org.caudexorigo.http.netty4.reporting.MessageBody;
import org.caudexorigo.http.netty4.reporting.ResponseFormatter;
import org.caudexorigo.io.UnsynchronizedStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardResponseFormatter
implements ResponseFormatter {
    private static Logger log = LoggerFactory.getLogger(StandardResponseFormatter.class);
    private final boolean showFullErrorInfo;

    public StandardResponseFormatter(boolean showFullErrorInfo) {
        this.showFullErrorInfo = showFullErrorInfo;
    }

    @Override
    public void formatResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        this.formatResponse(ctx, request, response, null);
    }

    @Override
    public void formatResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response, Throwable error) {
        if (MessageBody.allow(response.getStatus().code())) {
            try {
                Throwable root = ErrorAnalyser.findRootCause((Throwable)error);
                String html = String.format(ErrorTemplates.getTemplate(response.getStatus().code()), response.getStatus().code(), response.getStatus().reasonPhrase(), request.getMethod().toString(), this.getStackTrace(root, this.showFullErrorInfo));
                byte[] bytes = html.toString().getBytes("UTF-8");
                response.content().writeBytes(bytes);
                response.headers().set("Content-Type", (Object)"text/html");
                this.logError(root);
            }
            catch (Throwable t) {
                this.logError(t);
            }
        }
    }

    private void logError(Throwable t) {
        if (this.showFullErrorInfo) {
            log.error(this.getMsg(t), t);
        } else {
            log.error(this.getMsg(t));
        }
    }

    public String getStackTrace(Throwable error, boolean fullInfo) {
        if (error != null) {
            if (fullInfo) {
                UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw);
                error.printStackTrace(pw);
                pw.flush();
                return sw.toString();
            }
            return this.getMsg(error);
        }
        return "N/A";
    }

    private String getMsg(Throwable error) {
        return StringUtils.defaultString((String)error.getMessage(), (String)"N/A");
    }
}

