/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.caudexorigo.netty.NettyContext;

public class DefaultNettyContext
implements NettyContext {
    private static final DefaultNettyContext instance = new DefaultNettyContext();
    private final ByteBufAllocator _allocator;
    private final Class<? extends ServerChannel> _serverChannelClass;
    private final Class<? extends Channel> _channelClass;
    private final Class<? extends DatagramChannel> _datagramChannelClass;
    private final EventLoopGroup _bossEventLoopGroup;
    private final EventLoopGroup _workerEventLoopGroup;

    private DefaultNettyContext() {
        String os_arch = System.getProperty("os.arch");
        boolean isARM = DefaultNettyContext.contains(os_arch, "arm");
        this._allocator = isARM ? UnpooledByteBufAllocator.DEFAULT : PooledByteBufAllocator.DEFAULT;
        if (Epoll.isAvailable()) {
            this._bossEventLoopGroup = new EpollEventLoopGroup();
            this._workerEventLoopGroup = new EpollEventLoopGroup();
            this._serverChannelClass = EpollServerSocketChannel.class;
            this._channelClass = EpollSocketChannel.class;
            this._datagramChannelClass = EpollDatagramChannel.class;
        } else {
            this._bossEventLoopGroup = new NioEventLoopGroup();
            this._workerEventLoopGroup = new NioEventLoopGroup();
            this._serverChannelClass = NioServerSocketChannel.class;
            this._channelClass = NioSocketChannel.class;
            this._datagramChannelClass = NioDatagramChannel.class;
        }
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this._allocator;
    }

    @Override
    public Class<? extends ServerChannel> getServerChannelClass() {
        return this._serverChannelClass;
    }

    @Override
    public Class<? extends Channel> getChannelClass() {
        return this._channelClass;
    }

    @Override
    public EventLoopGroup getBossEventLoopGroup() {
        return this._bossEventLoopGroup;
    }

    @Override
    public EventLoopGroup getWorkerEventLoopGroup() {
        return this._workerEventLoopGroup;
    }

    @Override
    public Class<? extends DatagramChannel> getDatagramChannelClass() {
        return this._datagramChannelClass;
    }

    private static final boolean contains(String instr, String searchstr) {
        if (instr != null && instr.trim().length() > 0) {
            return instr.contains(searchstr);
        }
        return false;
    }

    public static final NettyContext get() {
        return instance;
    }
}

