/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.caudexorigo.netty.NettyContext;

public class VoidNettyContext
implements NettyContext {
    private final Class<? extends ServerChannel> _serverChannelClass;
    private final Class<? extends Channel> _channelClass;
    private final Class<? extends DatagramChannel> _datagramChannelClass;

    public VoidNettyContext() {
        if (Epoll.isAvailable()) {
            this._serverChannelClass = EpollServerSocketChannel.class;
            this._channelClass = EpollSocketChannel.class;
            this._datagramChannelClass = EpollDatagramChannel.class;
        } else {
            this._serverChannelClass = NioServerSocketChannel.class;
            this._channelClass = NioSocketChannel.class;
            this._datagramChannelClass = NioDatagramChannel.class;
        }
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return UnpooledByteBufAllocator.DEFAULT;
    }

    @Override
    public Class<? extends ServerChannel> getServerChannelClass() {
        return this._serverChannelClass;
    }

    @Override
    public Class<? extends Channel> getChannelClass() {
        return this._channelClass;
    }

    @Override
    public Class<? extends DatagramChannel> getDatagramChannelClass() {
        return this._datagramChannelClass;
    }

    @Override
    public EventLoopGroup getBossEventLoopGroup() {
        return null;
    }

    @Override
    public EventLoopGroup getWorkerEventLoopGroup() {
        return null;
    }
}

