/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.function.BiConsumer;
import sun.nio.ch.FileChannelImpl;

public class IoUtil {
    public static final int BLOCK_SIZE = 4096;

    public static void fill(FileChannel fileChannel, long position, long length, byte value) {
        try {
            byte[] filler = new byte[4096];
            Arrays.fill(filler, value);
            ByteBuffer byteBuffer = ByteBuffer.wrap(filler);
            fileChannel.position(position);
            int blocks = (int)(length / 4096L);
            int blockRemainder = (int)(length % 4096L);
            for (int i = 0; i < blocks; ++i) {
                byteBuffer.position(0);
                fileChannel.write(byteBuffer);
            }
            if (blockRemainder > 0) {
                byteBuffer.position(0);
                byteBuffer.limit(blockRemainder);
                fileChannel.write(byteBuffer);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void delete(File file, boolean ignoreFailures) {
        File[] files;
        if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File f : files) {
                IoUtil.delete(f, ignoreFailures);
            }
        }
        if (!file.delete() && !ignoreFailures) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void ensureDirectoryExists(File directory, String descriptionLabel) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IllegalArgumentException("could not create " + descriptionLabel + " directory: " + directory);
        }
    }

    public static void ensureDirectoryIsRecreated(File directory, String descriptionLabel, BiConsumer<String, String> callback) {
        if (directory.exists()) {
            IoUtil.delete(directory, false);
            callback.accept(directory.getAbsolutePath(), descriptionLabel);
        }
        if (!directory.mkdirs()) {
            throw new IllegalArgumentException("could not create " + descriptionLabel + " directory: " + directory);
        }
    }

    public static void deleteIfExists(File file) {
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static FileChannel createEmptyFile(File file, long size) {
        IoUtil.ensureDirectoryExists(file.getParentFile(), file.getParent());
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel templateFile = randomAccessFile.getChannel();
            IoUtil.fill(templateFile, 0L, size, (byte)0);
            return templateFile;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer mapExistingFile(File location, String descriptionLabel) {
        IoUtil.checkFileExists(location, descriptionLabel);
        try (RandomAccessFile file = new RandomAccessFile(location, "rw");){
            FileChannel channel = file.getChannel();
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, channel.size());
            return mappedByteBuffer;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer mapExistingFile(File location, String descriptionLabel, long offset, long size) {
        IoUtil.checkFileExists(location, descriptionLabel);
        try (RandomAccessFile file = new RandomAccessFile(location, "rw");){
            FileChannel channel = file.getChannel();
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, offset, size);
            return mappedByteBuffer;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer mapNewFile(File location, long size) {
        try (FileChannel channel = IoUtil.createEmptyFile(location, size);){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
            return mappedByteBuffer;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void checkFileExists(File file, String name) {
        if (!file.exists()) {
            String msg = String.format("Missing file for %1$s: %2$s", name, file.getAbsolutePath());
            throw new IllegalStateException(msg);
        }
    }

    public static void unmap(MappedByteBuffer buffer) {
        if (null == buffer) {
            return;
        }
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            method.setAccessible(true);
            method.invoke(null, buffer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String tmpDirName() {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        if (!tmpDirName.endsWith(File.separator)) {
            tmpDirName = tmpDirName + File.separator;
        }
        return tmpDirName;
    }
}

