/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class AtomicArray<T>
implements Collection<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final AtomicReference<T[]> arrayRef = new AtomicReference<Object[]>(EMPTY_ARRAY);

    public T get(int index) {
        return this.arrayRef.get()[index];
    }

    public T findFirst(Predicate<T> function) {
        T[] array;
        for (T e : array = this.arrayRef.get()) {
            if (!function.test(e)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        T[] array;
        for (T e : array = this.arrayRef.get()) {
            action.accept(e);
        }
    }

    public int doAction(ToIntFunction<? super T> action) {
        return this.doAction(0, action);
    }

    public int doAction(int fromIndex, ToIntFunction<? super T> action) {
        T[] array = this.arrayRef.get();
        int length = array.length;
        if (length == 0) {
            return 0;
        }
        fromIndex = AtomicArray.adjustForOverrun(fromIndex, length);
        int actionCount = 0;
        int i = fromIndex;
        do {
            actionCount += action.applyAsInt(array[i]);
            if (++i != length) continue;
            i = 0;
        } while (i != fromIndex);
        return actionCount;
    }

    public int doLimitedAction(int fromIndex, int actionCountLimit, ToIntLimitedFunction<? super T> action) {
        T[] array = this.arrayRef.get();
        int length = array.length;
        if (length == 0) {
            return 0;
        }
        fromIndex = AtomicArray.adjustForOverrun(fromIndex, length);
        int actionCount = 0;
        int i = fromIndex;
        while (actionCount < actionCountLimit) {
            actionCount += action.apply(array[i], actionCountLimit - actionCount);
            if (++i == length) {
                i = 0;
            }
            if (i != fromIndex) continue;
        }
        return actionCount;
    }

    @Override
    public boolean add(T element) {
        if (null == element) {
            throw new NullPointerException("element cannot be null");
        }
        Object[] oldArray = this.arrayRef.get();
        Object[] newArray = AtomicArray.append(oldArray, element);
        this.arrayRef(newArray);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element::equals) != null;
    }

    public T remove(Predicate<T> predicate) {
        T[] oldArray = this.arrayRef.get();
        if (oldArray == null || oldArray == EMPTY_ARRAY) {
            this.arrayRef(EMPTY_ARRAY);
            return null;
        }
        if (oldArray.length == 1) {
            T element = oldArray[0];
            if (predicate.test(element)) {
                this.arrayRef(EMPTY_ARRAY);
                return element;
            }
            return null;
        }
        int index = this.find(oldArray, predicate);
        if (-1 == index) {
            return null;
        }
        Object[] newArray = new Object[oldArray.length - 1];
        System.arraycopy(oldArray, 0, newArray, 0, index);
        System.arraycopy(oldArray, index + 1, newArray, index, newArray.length - index);
        this.arrayRef(newArray);
        return oldArray[index];
    }

    private void arrayRef(Object[] emptyArray) {
        this.arrayRef.lazySet(emptyArray);
    }

    @Override
    public int size() {
        return this.arrayRef.get().length;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator(this.arrayRef.get());
    }

    @Override
    public boolean isEmpty() {
        return this.arrayRef.get().length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return -1 != this.find(this.arrayRef.get(), o);
    }

    @Override
    public Object[] toArray() {
        T[] theArray = this.arrayRef.get();
        return Arrays.copyOf(theArray, theArray.length);
    }

    @Override
    public void clear() {
        this.arrayRef(EMPTY_ARRAY);
    }

    public String toString() {
        return "AtomicArray{arrayRef=" + Arrays.toString(this.arrayRef.get()) + '}';
    }

    private static int adjustForOverrun(int index, int length) {
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private int find(T[] array, Object item) {
        return this.find(array, item::equals);
    }

    private int find(T[] array, Predicate<T> item) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    private static Object[] append(Object[] oldArray, Object newElement) {
        Object[] newArray = Arrays.copyOf(oldArray, oldArray.length + 1);
        newArray[oldArray.length] = newElement;
        return newArray;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.toArray();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] array;
        private int index;

        private ArrayIterator(T[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }
    }

    @FunctionalInterface
    public static interface ToIntLimitedFunction<T> {
        public int apply(T var1, int var2);
    }
}

