/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.Head;
import uk.co.real_logic.agrona.concurrent.Padding3;
import uk.co.real_logic.agrona.concurrent.Tail;

public class OneToOneConcurrentArrayQueue<E>
extends Padding3
implements Queue<E> {
    private static final int ARRAY_BASE;
    private static final int SHIFT_FOR_SCALE;
    private static final long TAIL_OFFSET;
    private static final long HEAD_OFFSET;
    private final long mask;
    private final E[] buffer;

    public OneToOneConcurrentArrayQueue(int requestedCapacity) {
        int capacity = BitUtil.findNextPositivePowerOfTwo(requestedCapacity);
        this.mask = capacity - 1;
        this.buffer = new Object[capacity];
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full");
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        E[] buffer = this.buffer;
        long currentTail = this.tail;
        long offset = this.sequenceToOffset(currentTail);
        if (null == UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset)) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
            this.tailOrdered(currentTail + 1L);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        E[] buffer = this.buffer;
        long currentHead = this.head;
        long offset = this.sequenceToOffset(currentHead);
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
        if (null != e) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, null);
            this.headOrdered(currentHead + 1L);
        }
        return (E)e;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E peek() {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, this.sequenceToOffset(this.head));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drain(Consumer<E> elementHandler) {
        long currentHead = this.head;
        long currentTail = this.tail;
        long nextSequence = currentHead;
        try {
            while (nextSequence < currentTail) {
                elementHandler.accept(this.removeSequence(nextSequence++));
            }
        }
        finally {
            this.headOrdered(nextSequence);
        }
        return (int)(currentTail - currentHead);
    }

    @Override
    public int size() {
        long currentTail;
        long currentHeadBefore;
        long currentHeadAfter = this.head;
        do {
            currentHeadBefore = currentHeadAfter;
            currentTail = this.tail;
        } while ((currentHeadAfter = this.head) != currentHeadBefore);
        return (int)(currentTail - currentHeadAfter);
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public boolean contains(Object o) {
        if (null == o) {
            return false;
        }
        E[] buffer = this.buffer;
        long limit = this.tail;
        for (long i = this.head; i < limit; ++i) {
            Object e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, this.sequenceToOffset(i));
            if (!o.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        E value;
        while (null != (value = this.poll())) {
        }
    }

    private void tailOrdered(long tail) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, TAIL_OFFSET, tail);
    }

    private void headOrdered(long head) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, head);
    }

    private long sequenceToOffset(long sequence) {
        return (long)ARRAY_BASE + ((sequence & this.mask) << SHIFT_FOR_SCALE);
    }

    private E removeSequence(long sequence) {
        E[] buffer = this.buffer;
        long offset = this.sequenceToOffset(sequence);
        Object e = UnsafeAccess.UNSAFE.getObject(buffer, offset);
        UnsafeAccess.UNSAFE.putObject(buffer, offset, null);
        return (E)e;
    }

    static {
        try {
            ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
            SHIFT_FOR_SCALE = BitUtil.calculateShiftForScale(UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class));
            TAIL_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(Tail.class.getDeclaredField("tail"));
            HEAD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(Head.class.getDeclaredField("head"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

