/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.broadcast;

import java.util.concurrent.atomic.AtomicLong;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import uk.co.real_logic.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastReceiver {
    private final AtomicBuffer buffer;
    private final int capacity;
    private final int mask;
    private final int tailCounterIndex;
    private final int latestCounterIndex;
    private int recordOffset = 0;
    private long cursor = 0L;
    private long nextRecord = 0L;
    private final AtomicLong lappedCount = new AtomicLong();

    public BroadcastReceiver(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - 128;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        this.mask = this.capacity - 1;
        this.tailCounterIndex = this.capacity + 64;
        this.latestCounterIndex = this.capacity + 72;
    }

    public int capacity() {
        return this.capacity;
    }

    public long lappedCount() {
        return this.lappedCount.get();
    }

    public int typeId() {
        return this.buffer.getInt(RecordDescriptor.msgTypeOffset(this.recordOffset));
    }

    public int offset() {
        return RecordDescriptor.msgOffset(this.recordOffset);
    }

    public int length() {
        return this.buffer.getInt(RecordDescriptor.msgLengthOffset(this.recordOffset));
    }

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    public boolean receiveNext() {
        long cursor;
        AtomicBuffer buffer = this.buffer;
        long tail = buffer.getLongVolatile(this.tailCounterIndex);
        if (tail > (cursor = this.nextRecord)) {
            this.recordOffset = (int)cursor & this.mask;
            if (!this.validate(buffer, cursor)) {
                this.lappedCount.lazySet(this.lappedCount.get() + 1L);
                cursor = buffer.getLongVolatile(this.latestCounterIndex);
                this.recordOffset = (int)cursor & this.mask;
            }
            this.cursor = cursor;
            this.nextRecord = cursor + (long)buffer.getInt(RecordDescriptor.recLengthOffset(this.recordOffset));
            if (-1 == buffer.getInt(RecordDescriptor.msgTypeOffset(this.recordOffset))) {
                this.recordOffset = 0;
                this.cursor = this.nextRecord;
                this.nextRecord += (long)buffer.getInt(RecordDescriptor.recLengthOffset(this.recordOffset));
            }
            return true;
        }
        return false;
    }

    public boolean validate() {
        UnsafeAccess.UNSAFE.loadFence();
        return this.validate(this.buffer, this.cursor);
    }

    private boolean validate(AtomicBuffer buffer, long cursor) {
        return cursor == buffer.getLongVolatile(RecordDescriptor.tailSequenceOffset(this.recordOffset));
    }
}

