/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.broadcast;

import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import uk.co.real_logic.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastTransmitter {
    private final AtomicBuffer buffer;
    private final int capacity;
    private final int mask;
    private final int maxMsgLength;
    private final int tailCounterIndex;
    private final int latestCounterIndex;

    public BroadcastTransmitter(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - 128;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        this.mask = this.capacity - 1;
        this.maxMsgLength = RecordDescriptor.calculateMaxMessageLength(this.capacity);
        this.tailCounterIndex = this.capacity + 64;
        this.latestCounterIndex = this.capacity + 72;
    }

    public int capacity() {
        return this.capacity;
    }

    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    public void transmit(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        RecordDescriptor.checkMsgTypeId(msgTypeId);
        this.checkMessageLength(length);
        AtomicBuffer buffer = this.buffer;
        long tail = buffer.getLong(this.tailCounterIndex);
        int recordOffset = (int)tail & this.mask;
        int recordLength = BitUtil.align(length + 24, 32);
        int remainingBuffer = this.capacity - recordOffset;
        if (remainingBuffer < recordLength) {
            BroadcastTransmitter.insertPaddingRecord(buffer, tail, recordOffset, remainingBuffer);
            tail += (long)remainingBuffer;
            recordOffset = 0;
        }
        buffer.putLongOrdered(RecordDescriptor.tailSequenceOffset(recordOffset), tail);
        buffer.putInt(RecordDescriptor.recLengthOffset(recordOffset), recordLength);
        buffer.putInt(RecordDescriptor.msgLengthOffset(recordOffset), length);
        buffer.putInt(RecordDescriptor.msgTypeOffset(recordOffset), msgTypeId);
        buffer.putBytes(RecordDescriptor.msgOffset(recordOffset), srcBuffer, srcIndex, length);
        this.putLatestCounter(buffer, tail);
        this.incrementTailOrdered(buffer, tail, recordLength);
    }

    private void putLatestCounter(AtomicBuffer buffer, long tail) {
        buffer.putLong(this.latestCounterIndex, tail);
    }

    private void incrementTailOrdered(AtomicBuffer buffer, long tail, int recordLength) {
        buffer.putLongOrdered(this.tailCounterIndex, tail + (long)recordLength);
    }

    private static void insertPaddingRecord(AtomicBuffer buffer, long tail, int recordOffset, int remainingBuffer) {
        buffer.putLongOrdered(RecordDescriptor.tailSequenceOffset(recordOffset), tail);
        buffer.putInt(RecordDescriptor.recLengthOffset(recordOffset), remainingBuffer);
        buffer.putInt(RecordDescriptor.msgLengthOffset(recordOffset), 0);
        buffer.putInt(RecordDescriptor.msgTypeOffset(recordOffset), -1);
    }

    private void checkMessageLength(int length) {
        if (length > this.maxMsgLength) {
            String msg = String.format("encoded message exceeds maxMsgLength of %d, length=%d", this.maxMsgLength, length);
            throw new IllegalArgumentException(msg);
        }
    }
}

