/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.ringbuffer;

import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.MessageHandler;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RecordDescriptor;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RingBuffer;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class ManyToOneRingBuffer
implements RingBuffer {
    public static final int PADDING_MSG_TYPE_ID = -1;
    public static final int INSUFFICIENT_CAPACITY = -1;
    private final AtomicBuffer buffer;
    private final int capacity;
    private final int mask;
    private final int maxMsgLength;
    private final int tailCounterIndex;
    private final int headCounterIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;

    public ManyToOneRingBuffer(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - RingBufferDescriptor.TRAILER_LENGTH;
        RingBufferDescriptor.checkCapacity(this.capacity);
        this.mask = this.capacity - 1;
        this.maxMsgLength = this.capacity / 8;
        this.tailCounterIndex = this.capacity + RingBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.headCounterIndex = this.capacity + RingBufferDescriptor.HEAD_COUNTER_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        RecordDescriptor.checkMsgTypeId(msgTypeId);
        this.checkMsgLength(length);
        AtomicBuffer buffer = this.buffer;
        int requiredCapacity = BitUtil.align(length + 16, 32);
        int recordIndex = this.claimCapacity(buffer, requiredCapacity);
        if (-1 == recordIndex) {
            return false;
        }
        ManyToOneRingBuffer.msgLength(buffer, recordIndex, length);
        ManyToOneRingBuffer.msgType(buffer, recordIndex, msgTypeId);
        ManyToOneRingBuffer.writeMsg(buffer, recordIndex, srcBuffer, srcIndex, length);
        ManyToOneRingBuffer.recordLengthOrdered(buffer, recordIndex, requiredCapacity);
        return true;
    }

    @Override
    public int read(MessageHandler handler) {
        return this.read(handler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler handler, int messageCountLimit) {
        AtomicBuffer buffer = this.buffer;
        long tail = this.tailVolatile(buffer);
        long head = this.headVolatile(buffer);
        int available = (int)(tail - head);
        int messagesRead = 0;
        if (available > 0) {
            int headIndex = (int)head & this.mask;
            int contiguousBlockSize = Math.min(available, this.capacity - headIndex);
            int bytesRead = 0;
            try {
                while (bytesRead < contiguousBlockSize && messagesRead < messageCountLimit) {
                    int recordIndex = headIndex + bytesRead;
                    int recordLength = ManyToOneRingBuffer.waitForRecordLengthVolatile(buffer, recordIndex);
                    int msgLength = ManyToOneRingBuffer.msgLength(buffer, recordIndex);
                    int msgTypeId = ManyToOneRingBuffer.msgType(buffer, recordIndex);
                    bytesRead += recordLength;
                    if (msgTypeId == -1) continue;
                    ++messagesRead;
                    handler.onMessage(msgTypeId, buffer, RecordDescriptor.encodedMsgOffset(recordIndex), msgLength);
                }
            }
            finally {
                ManyToOneRingBuffer.zeroBuffer(buffer, headIndex, bytesRead);
                this.headOrdered(buffer, head + (long)bytesRead);
            }
        }
        return messagesRead;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTimeNs(long time) {
        this.consumerHeartbeatOrdered(this.buffer, time);
    }

    @Override
    public long consumerHeartbeatTimeNs() {
        return this.consumerHeartbeatVolatile(this.buffer);
    }

    private void checkMsgLength(int length) {
        if (length > this.maxMsgLength) {
            String msg = String.format("encoded message exceeds maxMsgLength of %d, length=%d", this.maxMsgLength, length);
            throw new IllegalArgumentException(msg);
        }
    }

    private int claimCapacity(AtomicBuffer buffer, int requiredCapacity) {
        int tailIndex;
        int padding;
        long tail;
        long head = this.headVolatile(buffer);
        int headIndex = (int)head & this.mask;
        do {
            int availableCapacity;
            if (requiredCapacity > (availableCapacity = this.capacity - (int)((tail = this.tailVolatile(buffer)) - head))) {
                return -1;
            }
            padding = 0;
            tailIndex = (int)tail & this.mask;
            int bufferEndSize = this.capacity - tailIndex;
            if (requiredCapacity <= bufferEndSize) continue;
            if (requiredCapacity > headIndex) {
                return -1;
            }
            padding = bufferEndSize;
        } while (!buffer.compareAndSetLong(this.tailCounterIndex, tail, tail + (long)requiredCapacity + (long)padding));
        if (0 != padding) {
            ManyToOneRingBuffer.writePaddingRecord(buffer, tailIndex, padding);
            tailIndex = 0;
        }
        return tailIndex;
    }

    private long tailVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(this.tailCounterIndex);
    }

    private long headVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(this.headCounterIndex);
    }

    private long consumerHeartbeatVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    private void headOrdered(AtomicBuffer buffer, long value) {
        buffer.putLongOrdered(this.headCounterIndex, value);
    }

    private void consumerHeartbeatOrdered(AtomicBuffer buffer, long value) {
        buffer.putLongOrdered(this.consumerHeartbeatIndex, value);
    }

    private static void writePaddingRecord(AtomicBuffer buffer, int recordIndex, int padding) {
        ManyToOneRingBuffer.msgType(buffer, recordIndex, -1);
        ManyToOneRingBuffer.recordLengthOrdered(buffer, recordIndex, padding);
    }

    private static void recordLengthOrdered(AtomicBuffer buffer, int recordIndex, int length) {
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), length);
    }

    private static void msgLength(AtomicBuffer buffer, int recordIndex, int length) {
        buffer.putInt(RecordDescriptor.msgLengthOffset(recordIndex), length);
    }

    private static void msgType(AtomicBuffer buffer, int recordIndex, int msgTypeId) {
        buffer.putInt(RecordDescriptor.msgTypeOffset(recordIndex), msgTypeId);
    }

    private static void writeMsg(AtomicBuffer buffer, int recordIndex, DirectBuffer srcBuffer, int srcIndex, int length) {
        buffer.putBytes(RecordDescriptor.encodedMsgOffset(recordIndex), srcBuffer, srcIndex, length);
    }

    private static int msgType(AtomicBuffer buffer, int recordIndex) {
        return buffer.getInt(RecordDescriptor.msgTypeOffset(recordIndex));
    }

    private static int msgLength(AtomicBuffer buffer, int recordIndex) {
        return buffer.getInt(RecordDescriptor.msgLengthOffset(recordIndex));
    }

    private static int waitForRecordLengthVolatile(AtomicBuffer buffer, int recordIndex) {
        int recordLength;
        while (0 == (recordLength = buffer.getIntVolatile(RecordDescriptor.lengthOffset(recordIndex)))) {
        }
        return recordLength;
    }

    private static void zeroBuffer(AtomicBuffer buffer, int position, int length) {
        buffer.setMemory(position, length, (byte)0);
    }
}

