/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.status;

import uk.co.real_logic.agrona.concurrent.CountersManager;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.agrona.status.PositionReporter;

public class BufferPositionReporter
implements PositionReporter {
    private final UnsafeBuffer buffer;
    private final int counterId;
    private final CountersManager countersManager;
    private final int offset;

    public BufferPositionReporter(UnsafeBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public BufferPositionReporter(UnsafeBuffer buffer, int counterId, CountersManager countersManager) {
        this.buffer = buffer;
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.offset = CountersManager.counterOffset(counterId);
    }

    @Override
    public void position(long value) {
        this.buffer.putLongOrdered(this.offset, value);
    }

    @Override
    public long position() {
        return this.buffer.getLongVolatile(this.offset);
    }

    @Override
    public void close() {
        this.countersManager.free(this.counterId);
    }

    @Override
    public int id() {
        return this.counterId;
    }
}

