/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.observation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.commons.webdav.EventUtil;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.AdditionalEventInfo;
import org.apache.jackrabbit.spi.commons.SessionExtensions;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.transaction.TransactionListener;
import org.apache.jackrabbit.webdav.observation.DefaultEventType;
import org.apache.jackrabbit.webdav.observation.EventBundle;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.EventType;
import org.apache.jackrabbit.webdav.observation.Filter;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.observation.ObservationResource;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.transaction.TransactionResource;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscriptionImpl
implements Subscription,
ObservationConstants,
EventListener {
    private static Logger log = LoggerFactory.getLogger(SubscriptionImpl.class);
    private static final long DEFAULT_TIMEOUT = 300000L;
    private SubscriptionInfo info;
    private long expirationTime;
    private final DavResourceLocator locator;
    private final String subscriptionId = UUID.randomUUID().toString();
    private final List<EventBundle> eventBundles = new ArrayList<EventBundle>();
    private final ObservationManager obsMgr;
    private final Session session;

    public SubscriptionImpl(SubscriptionInfo info, ObservationResource resource) throws DavException {
        this.setInfo(info);
        this.locator = resource.getLocator();
        this.session = JcrDavSession.getRepositorySession(resource.getSession());
        try {
            this.obsMgr = this.session.getWorkspace().getObservationManager();
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean eventsProvideNodeTypeInformation() {
        String t = this.session.getRepository().getDescriptor("org.apache.jackrabbit.spi.commons.AdditionalEventInfo");
        return t == null ? false : Boolean.parseBoolean(t);
    }

    public boolean eventsProvideNoLocalFlag() {
        return this.session instanceof SessionExtensions;
    }

    public Element toXml(Document document) {
        Element subscr = DomUtil.createElement((Document)document, (String)"subscription", (Namespace)NAMESPACE);
        subscr.appendChild(this.info.toXml(document));
        subscr.appendChild(DomUtil.depthToXml((boolean)this.info.isDeep(), (Document)document));
        subscr.appendChild(DomUtil.timeoutToXml((long)this.info.getTimeOut(), (Document)document));
        if (this.getSubscriptionId() != null) {
            Element id = DomUtil.addChildElement((Element)subscr, (String)"subscriptionid", (Namespace)NAMESPACE);
            id.appendChild(DomUtil.hrefToXml((String)this.getSubscriptionId(), (Document)document));
        }
        DomUtil.addChildElement((Element)subscr, (String)"eventswithnodetypes", (Namespace)NAMESPACE, (String)Boolean.toString(this.eventsProvideNodeTypeInformation()));
        DomUtil.addChildElement((Element)subscr, (String)"eventswithlocalflag", (Namespace)NAMESPACE, (String)Boolean.toString(this.eventsProvideNoLocalFlag()));
        return subscr;
    }

    void setInfo(SubscriptionInfo info) {
        this.info = info;
        long timeout = info.getTimeOut();
        if (timeout <= 0L) {
            timeout = 300000L;
        }
        this.expirationTime = System.currentTimeMillis() + timeout;
    }

    int getJcrEventTypes() throws DavException {
        EventType[] eventTypes = this.info.getEventTypes();
        int events = 0;
        for (EventType eventType : eventTypes) {
            events |= SubscriptionImpl.getJcrEventType(eventType);
        }
        return events;
    }

    String[] getUuidFilters() {
        return this.getFilterValues("uuid");
    }

    String[] getNodetypeNameFilters() {
        return this.getFilterValues("nodetype-name");
    }

    private String[] getFilterValues(String filterLocalName) {
        ArrayList<String> values = new ArrayList<String>();
        for (Filter filter : this.info.getFilters(filterLocalName, NAMESPACE)) {
            String val = filter.getValue();
            if (val == null) continue;
            values.add(val);
        }
        return values.size() > 0 ? values.toArray(new String[values.size()]) : null;
    }

    boolean isNoLocal() {
        return this.info.isNoLocal();
    }

    boolean isDeep() {
        return this.info.isDeep();
    }

    DavResourceLocator getLocator() {
        return this.locator;
    }

    boolean isSubscribedToResource(ObservationResource resource) {
        return this.locator.getResourcePath().equals(resource.getResourcePath());
    }

    boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    synchronized EventDiscovery discoverEvents(long timeout) {
        EventDiscovery ed = new EventDiscovery();
        if (this.eventBundles.isEmpty() && timeout > 0L) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (EventBundle eb : this.eventBundles) {
            ed.addEventBundle(eb);
        }
        this.eventBundles.clear();
        return ed;
    }

    TransactionListener createTransactionListener() {
        if (this.info.isNoLocal()) {
            return new TransactionEvent(){

                @Override
                public void onEvent(EventIterator events) {
                }

                @Override
                public void beforeCommit(TransactionResource resource, String lockToken) {
                }

                @Override
                public void afterCommit(TransactionResource resource, String lockToken, boolean success) {
                }
            };
        }
        return new TransactionEvent();
    }

    void suspend() throws DavException {
        try {
            this.obsMgr.removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    void resume() throws DavException {
        try {
            this.obsMgr.addEventListener((EventListener)this, this.getJcrEventTypes(), this.getLocator().getRepositoryPath(), this.isDeep(), this.getUuidFilters(), this.getNodetypeNameFilters(), this.isNoLocal());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public synchronized void onEvent(EventIterator events) {
        if (!this.isExpired()) {
            this.eventBundles.add(new EventBundleImpl(events));
        } else {
            try {
                this.obsMgr.removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.warn("Exception while unsubscribing: " + (Object)((Object)e));
            }
        }
        this.notifyAll();
    }

    public static EventType getEventType(int jcrEventType) {
        String localName = EventUtil.getEventName((int)jcrEventType);
        return DefaultEventType.create((String)localName, (Namespace)NAMESPACE);
    }

    public static EventType[] getAllEventTypes() {
        EventType[] types = DefaultEventType.create((String[])EventUtil.EVENT_ALL, (Namespace)NAMESPACE);
        return types;
    }

    public static int getJcrEventType(EventType eventType) throws DavException {
        if (eventType == null || !NAMESPACE.equals((Object)eventType.getNamespace())) {
            throw new DavException(422, "Invalid JCR event type: " + eventType + ": Namespace mismatch.");
        }
        String eventName = eventType.getName();
        if (!EventUtil.isValidEventName((String)eventName)) {
            throw new DavException(422, "Invalid event type: " + eventName);
        }
        return EventUtil.getJcrEventType((String)eventName);
    }

    private class TransactionEvent
    implements EventListener,
    TransactionListener {
        private String transactionId;

        private TransactionEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(EventIterator events) {
            String tId = this.transactionId;
            if (tId == null) {
                tId = UUID.randomUUID().toString();
            }
            SubscriptionImpl subscriptionImpl = SubscriptionImpl.this;
            synchronized (subscriptionImpl) {
                SubscriptionImpl.this.eventBundles.add(new EventBundleImpl(events, tId));
                SubscriptionImpl.this.notifyAll();
            }
        }

        @Override
        public void beforeCommit(TransactionResource resource, String lockToken) {
            try {
                this.transactionId = lockToken;
                SubscriptionImpl.this.obsMgr.addEventListener((EventListener)this, SubscriptionImpl.this.getJcrEventTypes(), SubscriptionImpl.this.getLocator().getRepositoryPath(), SubscriptionImpl.this.isDeep(), SubscriptionImpl.this.getUuidFilters(), SubscriptionImpl.this.getNodetypeNameFilters(), SubscriptionImpl.this.isNoLocal());
                SubscriptionImpl.this.suspend();
            }
            catch (RepositoryException e) {
                log.warn("Unable to register TransactionListener: " + (Object)((Object)e));
            }
            catch (DavException e) {
                log.warn("Unable to register TransactionListener: " + (Object)((Object)e));
            }
        }

        @Override
        public void afterCommit(TransactionResource resource, String lockToken, boolean success) {
            try {
                SubscriptionImpl.this.resume();
                SubscriptionImpl.this.obsMgr.removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.warn("Unable to remove listener: " + (Object)((Object)e));
            }
            catch (DavException e) {
                log.warn("Unable to resume Subscription: " + (Object)((Object)e));
            }
        }
    }

    private class EventBundleImpl
    implements EventBundle {
        private final EventIterator events;
        private final String transactionId;

        private EventBundleImpl(EventIterator events) {
            this(events, (String)null);
        }

        private EventBundleImpl(EventIterator events, String transactionId) {
            this.events = events;
            this.transactionId = transactionId;
        }

        public Element toXml(Document document) {
            Element bundle = DomUtil.createElement((Document)document, (String)"eventbundle", (Namespace)ObservationConstants.NAMESPACE);
            if (this.transactionId != null) {
                DomUtil.setAttribute((Element)bundle, (String)"transactionid", (Namespace)ObservationConstants.NAMESPACE, (String)this.transactionId);
            }
            boolean localFlagSet = false;
            while (this.events.hasNext()) {
                Event event = this.events.nextEvent();
                if (!localFlagSet) {
                    localFlagSet = true;
                    String name = "http://www.day.com/jcr/webdav/1.0/session-id";
                    Object forSessionId = SubscriptionImpl.this.session.getAttribute(name);
                    if (forSessionId != null && event instanceof AdditionalEventInfo) {
                        AdditionalEventInfo aei = (AdditionalEventInfo)event;
                        try {
                            boolean isLocal = forSessionId.equals(aei.getSessionAttribute(name));
                            DomUtil.setAttribute((Element)bundle, (String)"local", null, (String)Boolean.toString(isLocal));
                        }
                        catch (UnsupportedRepositoryOperationException ex) {
                            // empty catch block
                        }
                    }
                }
                Element eventElem = DomUtil.addChildElement((Element)bundle, (String)"event", (Namespace)ObservationConstants.NAMESPACE);
                String eHref = "";
                try {
                    boolean isCollection = event.getType() == 1 || event.getType() == 2;
                    eHref = SubscriptionImpl.this.locator.getFactory().createResourceLocator(SubscriptionImpl.this.locator.getPrefix(), SubscriptionImpl.this.locator.getWorkspacePath(), event.getPath(), false).getHref(isCollection);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                eventElem.appendChild(DomUtil.hrefToXml((String)eHref, (Document)document));
                Element eType = DomUtil.addChildElement((Element)eventElem, (String)"eventtype", (Namespace)ObservationConstants.NAMESPACE);
                eType.appendChild(SubscriptionImpl.getEventType(event.getType()).toXml(document));
                DomUtil.addChildElement((Element)eventElem, (String)"eventuserid", (Namespace)ObservationConstants.NAMESPACE, (String)event.getUserID());
                if (event instanceof AdditionalEventInfo) {
                    try {
                        DomUtil.addChildElement((Element)eventElem, (String)"eventprimarynodetype", (Namespace)ObservationConstants.NAMESPACE, (String)((AdditionalEventInfo)event).getPrimaryNodeTypeName().toString());
                        for (Name mixin : ((AdditionalEventInfo)event).getMixinTypeNames()) {
                            DomUtil.addChildElement((Element)eventElem, (String)"eventmixinnodetype", (Namespace)ObservationConstants.NAMESPACE, (String)mixin.toString());
                        }
                    }
                    catch (UnsupportedRepositoryOperationException ex) {
                        // empty catch block
                    }
                }
                try {
                    DomUtil.addChildElement((Element)eventElem, (String)"eventuserdata", (Namespace)ObservationConstants.NAMESPACE, (String)event.getUserData());
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event user data. {}", (Object)e.getMessage());
                }
                try {
                    DomUtil.addChildElement((Element)eventElem, (String)"eventdate", (Namespace)ObservationConstants.NAMESPACE, (String)String.valueOf(event.getDate()));
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event date. {}", (Object)e.getMessage());
                }
                try {
                    DomUtil.addChildElement((Element)eventElem, (String)"eventidentifier", (Namespace)ObservationConstants.NAMESPACE, (String)event.getIdentifier());
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event identifier. {}", (Object)e.getMessage());
                }
                Element info = DomUtil.addChildElement((Element)eventElem, (String)"eventinfo", (Namespace)ObservationConstants.NAMESPACE);
                try {
                    Map m = event.getInfo();
                    for (Map.Entry entry : m.entrySet()) {
                        String key = entry.getKey().toString();
                        Object value = entry.getValue();
                        if (value != null) {
                            DomUtil.addChildElement((Element)info, (String)key, (Namespace)Namespace.EMPTY_NAMESPACE, (String)value.toString());
                            continue;
                        }
                        DomUtil.addChildElement((Element)info, (String)key, (Namespace)Namespace.EMPTY_NAMESPACE);
                    }
                }
                catch (RepositoryException e) {
                    log.error("Internal error while retrieving event info. {}", (Object)e.getMessage());
                }
            }
            return bundle;
        }
    }
}

